/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons.animations;

import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.azurelib.core.keyframe.event.data.SoundKeyframeData;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeCallbacks;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.item.enums.GunTypeEnum;
import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import mod.azure.hwg.item.weapons.FlareGunItem;
import mod.azure.hwg.item.weapons.GrenadeLauncherItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GunAnimator
extends AzItemAnimator {
    private static final ResourceLocation PISTOL_ANIMATIONS = CommonMod.modResource("animations/item/pistol/pistol.animation.json");
    private static final ResourceLocation MEANIE_ANIMATIONS = CommonMod.modResource("animations/item/meanie/meanie.animation.json");
    private static final ResourceLocation HELL_ANIMATIONS = CommonMod.modResource("animations/item/hellhorse_revolver/hellhorse_revolver.animation.json");
    private static final ResourceLocation GOLDEN_PISTOL_ANIMATIONS = CommonMod.modResource("animations/item/golden_gun/golden_gun.animation.json");
    private static final ResourceLocation FLARE_GUN_ANIMATIONS = CommonMod.modResource("animations/item/flare_gun/flare_gun.animation.json");
    private static final ResourceLocation FLAMETHROWER_ANIMATIONS = CommonMod.modResource("animations/item/flamethrower/flamethrower.animation.json");
    private static final ResourceLocation BRIMSTONE_GUN_ANIMATIONS = CommonMod.modResource("animations/item/brimstone_gun/brimstone_gun.animation.json");
    private static final ResourceLocation BALROG_GUN_ANIMATIONS = CommonMod.modResource("animations/item/balrog_gun/balrog_gun.animation.json");
    private static final ResourceLocation AK47_ANIMATIONS = CommonMod.modResource("animations/item/ak47/ak47.animation.json");
    private static final ResourceLocation GRENADE_LAUNCHER_ANIMATIONS = CommonMod.modResource("animations/item/grenade_launcher/grenade_launcher.animation.json");
    private static final ResourceLocation LUGER_ANIMATIONS = CommonMod.modResource("animations/item/luger/luger.animation.json");
    private static final ResourceLocation MINIGUN_ANIMATIONS = CommonMod.modResource("animations/item/minigun/minigun.animation.json");
    private static final ResourceLocation NOSTROMO_FLAMETHROWER_ANIMATIONS = CommonMod.modResource("animations/item/nostromo_flamethrower/nostromo_flamethrower.animation.json");
    private static final ResourceLocation ROCKET_LAUNCHER_ANIMATIONS = CommonMod.modResource("animations/item/rocketlauncher/rocketlauncher.animation.json");
    private static final ResourceLocation SHOTGUN_ANIMATIONS = CommonMod.modResource("animations/item/shotgun/shotgun.animation.json");
    private static final ResourceLocation SMG_ANIMATIONS = CommonMod.modResource("animations/item/smg/smg.animation.json");
    private static final ResourceLocation SNIPER_RIFLE_ANIMATIONS = CommonMod.modResource("animations/item/sniper_rifle/sniper_rifle.animation.json");
    private static final ResourceLocation TOMMY_GUN_ANIMATIONS = CommonMod.modResource("animations/item/tommy_gun/tommy_gun.animation.json");

    public void registerControllers(AzAnimationControllerContainer<ItemStack> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"base_controller").setKeyframeCallbacks(AzKeyframeCallbacks.builder().setSoundKeyframeHandler(event -> {
            if (((SoundKeyframeData)event.getKeyframeData()).getSound().equals("tank")) {
                ClientUtils.getClientPlayer().level().playLocalSound(ClientUtils.getClientPlayer().getX(), ClientUtils.getClientPlayer().getY(), ClientUtils.getClientPlayer().getZ(), SoundEvents.METAL_PLACE, SoundSource.HOSTILE, 0.5f, 1.0f, true);
            }
        }).build()).build(), new AzAnimationController[0]);
    }

    @NotNull
    public ResourceLocation getAnimationLocation(ItemStack animatable) {
        Item item = animatable.getItem();
        if (item instanceof FlareGunItem) {
            FlareGunItem flareGunItem = (FlareGunItem)item;
            return FLARE_GUN_ANIMATIONS;
        }
        item = animatable.getItem();
        if (item instanceof GrenadeLauncherItem) {
            GrenadeLauncherItem grenadeLauncherItem = (GrenadeLauncherItem)item;
            return GRENADE_LAUNCHER_ANIMATIONS;
        }
        item = animatable.getItem();
        if (item instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunItem = (AzureAnimatedGunItem)item;
            return switch (gunItem.getGunTypeEnum()) {
                case GunTypeEnum.PISTOL, GunTypeEnum.SIL_PISTOL, GunTypeEnum.SILVER_PISTOL -> PISTOL_ANIMATIONS;
                case GunTypeEnum.MEANIE -> MEANIE_ANIMATIONS;
                case GunTypeEnum.HELLHORSE, GunTypeEnum.SILVER_HELL -> HELL_ANIMATIONS;
                case GunTypeEnum.ROCKETLAUNCHER -> ROCKET_LAUNCHER_ANIMATIONS;
                case GunTypeEnum.AK7 -> AK47_ANIMATIONS;
                case GunTypeEnum.SMG -> SMG_ANIMATIONS;
                case GunTypeEnum.LUGER -> LUGER_ANIMATIONS;
                case GunTypeEnum.BALROG -> BALROG_GUN_ANIMATIONS;
                case GunTypeEnum.SNIPER -> SNIPER_RIFLE_ANIMATIONS;
                case GunTypeEnum.SHOTGUN -> SHOTGUN_ANIMATIONS;
                case GunTypeEnum.MINIGUN -> MINIGUN_ANIMATIONS;
                case GunTypeEnum.TOMMYGUN -> TOMMY_GUN_ANIMATIONS;
                case GunTypeEnum.BRIMSTONE -> BRIMSTONE_GUN_ANIMATIONS;
                case GunTypeEnum.FLAMETHROWER -> FLAMETHROWER_ANIMATIONS;
                case GunTypeEnum.GOLDEN_PISTOL -> GOLDEN_PISTOL_ANIMATIONS;
                default -> NOSTROMO_FLAMETHROWER_ANIMATIONS;
            };
        }
        return PISTOL_ANIMATIONS;
    }
}

