/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class SniperMixin {
    private static final ResourceLocation SNIPER = CommonMod.modResource("textures/gui/pumpkinblur.png");
    @Shadow
    private final Minecraft minecraft;
    private boolean scoped = true;

    protected SniperMixin(Minecraft client) {
        this.minecraft = client;
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    private void render(GuiGraphics guiGraphics, DeltaTracker partialTicks, CallbackInfo ci) {
        ItemStack itemStack = this.minecraft.player.getInventory().getSelected();
        if (this.minecraft.options.getCameraType().isFirstPerson() && itemStack.is((Item)HWGItems.SNIPER.get())) {
            if (ClientUtils.SCOPE.isDown()) {
                if (this.scoped) {
                    this.scoped = false;
                }
                this.renderSniperOverlay(guiGraphics, SNIPER);
            } else if (!this.scoped) {
                this.scoped = true;
            }
        }
    }

    private void renderSniperOverlay(GuiGraphics guiGraphics, ResourceLocation identifier) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)identifier);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(0.0f, (float)guiGraphics.guiHeight(), -90.0f).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex((float)guiGraphics.guiWidth(), (float)guiGraphics.guiHeight(), -90.0f).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex((float)guiGraphics.guiWidth(), 0.0f, -90.0f).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

