/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.mixins;

import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import mod.azure.hwg.item.weapons.HWGGunLoadedBase;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    protected VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="RETURN")}, method={"mobInteract"}, cancellable=true)
    private void killVillager(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> ci) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() instanceof AzureAnimatedGunItem || itemStack.getItem() instanceof HWGGunLoadedBase) {
            ci.setReturnValue((Object)InteractionResult.FAIL);
        }
    }
}

