/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class FlareParticle
extends TextureSheetParticle {
    private FlareParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, float red, float green, float blue) {
        super(world, x, y, z);
        this.scale(3.0f);
        this.setSize(0.25f, 0.25f);
        this.lifetime = this.random.nextInt(50) + 780;
        this.gravity = 3.0E-6f;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.alpha = 0.75f;
        this.xd = velocityX;
        this.yd = velocityY + (double)(this.random.nextFloat() / 500.0f);
        this.zd = velocityZ;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && this.alpha > 0.0f) {
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class OrangeSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public OrangeSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 58.0f, 179.0f, 216.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class MagentaSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public MagentaSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 94.0f, 124.0f, 22.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class LightBlueSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public LightBlueSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 249.0f, 128.0f, 29.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class YellowSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public YellowSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 60.0f, 68.0f, 170.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class LimeSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public LimeSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 137.0f, 50.0f, 184.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class PinkSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public PinkSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 10.0f, 150.0f, 156.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            campfireSmokeParticle.setAlpha(0.4f);
            return campfireSmokeParticle;
        }
    }

    public static class GraySmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public GraySmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 157.0f, 157.0f, 151.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class LightGraySmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public LightGraySmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 131.0f, 84.0f, 50.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class CyanSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public CyanSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 176.0f, 46.0f, 38.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class PurpleSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public PurpleSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 128.0f, 199.0f, 31.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class BlueSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public BlueSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 254.0f, 216.0f, 61.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class BrownSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public BrownSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 71.0f, 79.0f, 82.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class GreenSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public GreenSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 199.0f, 78.0f, 189.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class RedSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public RedSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 22.0f, 156.0f, 156.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }

    public static class BlackSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public BlackSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(@NotNull SimpleParticleType defaultParticleType, @NotNull ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            FlareParticle campfireSmokeParticle = new FlareParticle(clientWorld, d, e, f, g, h, i, 0.0f, 0.0f, 0.0f);
            campfireSmokeParticle.pickSprite(this.spriteProvider);
            return campfireSmokeParticle;
        }
    }
}

