/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.util;

import java.util.Optional;
import mod.azure.azurelib.common.internal.common.blocks.TickingLightBlock;
import mod.azure.azurelib.common.internal.common.blocks.TickingLightEntity;
import mod.azure.azurelib.common.internal.common.registry.AzureBlocksRegistry;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.projectiles.BlazeRodEntity;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.entity.projectiles.FireballEntity;
import mod.azure.hwg.entity.projectiles.FlameFiring;
import mod.azure.hwg.entity.projectiles.MBulletEntity;
import mod.azure.hwg.entity.projectiles.RocketEntity;
import mod.azure.hwg.entity.projectiles.SBulletEntity;
import mod.azure.hwg.entity.projectiles.ShellEntity;
import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class Helper {
    private Helper() {
    }

    public static void setOnFire(Entity projectile) {
        if (projectile.isOnFire()) {
            projectile.level().getEntitiesOfClass(LivingEntity.class, projectile.getBoundingBox().inflate(2.0)).forEach(e -> {
                if (e.isAlive() && !(e instanceof Player)) {
                    e.setRemainingFireTicks(90);
                }
            });
        }
    }

    public static void removeAmmo(Item ammo, Player playerEntity) {
        if (playerEntity.getItemInHand(playerEntity.getUsedItemHand()).getItem() instanceof AzureAnimatedGunItem && !playerEntity.isCreative()) {
            block0: for (ItemStack item : playerEntity.getInventory().offhand) {
                if (item.getItem() == ammo) {
                    item.shrink(1);
                    break;
                }
                for (ItemStack item1 : playerEntity.getInventory().items) {
                    if (item1.getItem() != ammo) continue;
                    item1.shrink(1);
                    continue block0;
                }
            }
        }
    }

    public static void spawnLightSource(Entity entity, Boolean isInWaterBlock) {
        BlockEntity blockEntity;
        BlockPos lightBlockPos = null;
        if (lightBlockPos == null) {
            lightBlockPos = Helper.findFreeSpace(entity.level(), entity.blockPosition());
            if (lightBlockPos == null) {
                return;
            }
            entity.level().setBlockAndUpdate(lightBlockPos, ((TickingLightBlock)AzureBlocksRegistry.TICKING_LIGHT_BLOCK.get()).defaultBlockState());
        } else if (Helper.checkDistance(lightBlockPos, entity.blockPosition()) && (blockEntity = entity.level().getBlockEntity(lightBlockPos)) instanceof TickingLightEntity) {
            TickingLightEntity tickingLightEntity = (TickingLightEntity)blockEntity;
            tickingLightEntity.refresh(Boolean.TRUE.equals(isInWaterBlock) ? 20 : 0);
        }
    }

    private static boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB) {
        return Math.abs(blockPosA.getX() - blockPosB.getX()) <= 2 && Math.abs(blockPosA.getY() - blockPosB.getY()) <= 2 && Math.abs(blockPosA.getZ() - blockPosB.getZ()) <= 2;
    }

    private static BlockPos findFreeSpace(Level world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[5];
        offsets[0] = 0;
        for (int i = 2; i <= 4; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.offset(x, y, z);
                    BlockState state = world.getBlockState(offsetPos);
                    if (!state.isAir() && !state.getBlock().equals(AzureBlocksRegistry.TICKING_LIGHT_BLOCK.get())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    public static EntityHitResult hitscanTrace(Player player, double range, float ticks) {
        Vec3 look = player.getViewVector(ticks);
        Vec3 start = player.getEyePosition(ticks);
        Vec3 end = new Vec3(player.getX() + look.x * range, player.getEyeY() + look.y * range, player.getZ() + look.z * range);
        double traceDistance = player.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getLocation().distanceToSqr(end);
        for (Entity possible : player.level().getEntities((Entity)player, player.getBoundingBox().expandTowards(look.scale(traceDistance)).expandTowards(3.0, 3.0, 3.0), entity -> !entity.isSpectator() && entity.isPickable() && entity instanceof LivingEntity)) {
            Optional clip = possible.getBoundingBox().inflate(0.3).clip(start, end);
            if (!clip.isPresent() || !(start.distanceToSqr((Vec3)clip.get()) < traceDistance)) continue;
            return ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)start, (Vec3)end, (AABB)player.getBoundingBox().expandTowards(look.scale(traceDistance)).inflate(3.0, 3.0, 3.0), target -> !target.isSpectator() && player.isAttackable() && player.hasLineOfSight(target));
        }
        return null;
    }

    public static BulletEntity createBullet(Level level, LivingEntity shooter, float damage) {
        BulletEntity bulletEntity = new BulletEntity(level, new ItemStack((ItemLike)Items.AIR), (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), false);
        bulletEntity.bulletdamage = damage;
        return bulletEntity;
    }

    public static BlazeRodEntity createBlazeRod(Level level, LivingEntity shooter) {
        return new BlazeRodEntity(level, new ItemStack((ItemLike)Items.AIR), (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), false);
    }

    public static FireballEntity createFireball(Level worldIn, LivingEntity shooter) {
        return new FireballEntity(worldIn, shooter);
    }

    public static FlameFiring createFlame(Level worldIn, LivingEntity shooter) {
        return new FlameFiring(worldIn, shooter);
    }

    public static MBulletEntity createMeanieBullet(Level level, LivingEntity shooter) {
        return new MBulletEntity(level, new ItemStack((ItemLike)Items.AIR), (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), false);
    }

    public static ShellEntity createShell(Level level, LivingEntity shooter) {
        return new ShellEntity(level, new ItemStack((ItemLike)Items.AIR), (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), false);
    }

    public static RocketEntity createRocket(Level worldIn, LivingEntity shooter) {
        return new RocketEntity(worldIn, shooter);
    }

    public static SBulletEntity createSilverBullet(Level level, LivingEntity shooter) {
        SBulletEntity bulletEntity = new SBulletEntity(level, new ItemStack((ItemLike)Items.AIR), (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), false);
        bulletEntity.bulletdamage = CommonMod.config.gunconfigs.hellhorseconfigs.hellhorse_damage;
        return bulletEntity;
    }
}

