/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.util.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mod.azure.hwg.client.gui.GunTableInventory;
import mod.azure.hwg.util.registry.ModRecipes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record GunTableRecipe(List<Pair<Ingredient, Integer>> ingredients, ItemStack output) implements Recipe<GunTableInventory.CustomRecipeInput>,
Comparable<GunTableRecipe>
{
    public boolean matches(@NotNull GunTableInventory.CustomRecipeInput inv, @NotNull Level world) {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack slotStack = inv.getItem(i);
            Pair<Ingredient, Integer> pair = this.ingredients.get(i);
            Ingredient ingredient = (Ingredient)pair.getFirst();
            Integer count = (Integer)pair.getSecond();
            if (slotStack.getCount() >= count && ingredient.test(slotStack)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull GunTableInventory.CustomRecipeInput craftingContainer, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public Ingredient getIngredientForSlot(int index) {
        return (Ingredient)this.ingredients.get(index).getFirst();
    }

    public int countRequired(int index) {
        return (Integer)this.ingredients.get(index).getSecond();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.GUN_TABLE_SERIAL.get();
    }

    @Override
    public int compareTo(@NotNull GunTableRecipe o) {
        Item outputThis = this.output.getItem();
        Item outputOther = o.output.getItem();
        return BuiltInRegistries.ITEM.getKey((Object)outputThis).compareTo(BuiltInRegistries.ITEM.getKey((Object)outputOther));
    }

    public static class Type
    implements RecipeType<GunTableRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "gun_table";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<GunTableRecipe> {
        public static Serializer INSTANCE = new Serializer();
        public static final MapCodec<GunTableRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.list((Codec)Codec.mapPair((MapCodec)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient"), (MapCodec)Codec.INT.fieldOf("count")).codec()).fieldOf("ingredients").forGetter(i -> i.ingredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(i -> i.output)).apply((Applicative)inst, GunTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GunTableRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<GunTableRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, GunTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static GunTableRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            List list = buffer.readList(buf -> Pair.of((Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)), (Object)buffer.readInt()));
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new GunTableRecipe(list, output);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, GunTableRecipe recipe) {
            buffer.writeCollection(recipe.ingredients, (buf, pair) -> {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((Ingredient)pair.getFirst()));
                buf.writeInt(((Integer)pair.getSecond()).intValue());
            });
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

