/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client;

import io.github.flemmli97.tenshilib.client.CustomRiderRendererManager;
import io.github.flemmli97.tenshilib.client.gui.AnimationScreen;
import io.github.flemmli97.tenshilib.common.entity.OverlayEntityRender;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.item.AnimationDebugger;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ClientHandlers {
    public static final Set<UUID> RIDING_RENDER_BLACKLIST = new HashSet<UUID>();

    public static void updateAnim(int entityID, String animID, int startTransition, int endTransition, double start) {
        Minecraft mc = Minecraft.getInstance();
        Entity e = mc.level.getEntity(entityID);
        if (e instanceof AnimatedEntity) {
            AnimatedEntity anim = (AnimatedEntity)e;
            anim.getAnimationHandler().setAnimation(animID.isEmpty() ? null : anim.getAnimationHandler().getAnimations().get(animID), startTransition, endTransition, start);
        }
    }

    public static int getColor(LivingEntity entity, float f) {
        OverlayEntityRender overlay = (OverlayEntityRender)entity;
        int oV = (int)(f * 15.0f);
        int oU = entity.hurtTime > 0 || entity.deathTime > 0 ? 3 : 10;
        return OverlayTexture.pack((int)overlay.overlayU(oV), (int)overlay.overlayV(oU));
    }

    public static boolean shouldDisableRender(Entity entity) {
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (CustomRiderRendererManager.getInstance().hasRiderLayerRenderer(vehicle.getType())) {
                if (RIDING_RENDER_BLACKLIST.contains(entity.getUUID())) {
                    return false;
                }
                return entity != Minecraft.getInstance().player || !Minecraft.getInstance().options.getCameraType().isFirstPerson();
            }
        }
        return false;
    }

    public static boolean onClientClick() {
        ExtendedWeapon weapon;
        Minecraft client = Minecraft.getInstance();
        ItemStack main = client.player.getMainHandItem();
        Item item = main.getItem();
        return item instanceof ExtendedWeapon && (weapon = (ExtendedWeapon)item).onClientStartAttack((LivingEntity)client.player, main, client.hitResult);
    }

    public static <T extends LivingEntity> void openAnimationGui(T entity, InteractionHand hand) {
        ItemStack stack = Minecraft.getInstance().player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof AnimationDebugger) {
            AnimationDebugger debug = (AnimationDebugger)item;
            Minecraft.getInstance().setScreen(new AnimationScreen<T>(entity, hand, debug.getId(stack)));
        }
    }
}

