/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.tenshilib.client.render.layer.RiderEntityLayer;
import io.github.flemmli97.tenshilib.mixin.LivingEntityRendererAccessor;
import io.github.flemmli97.tenshilib.mixinhelper.EntityRenderDispatcherAccess;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;

public class CustomRiderRendererManager
implements ResourceManagerReloadListener {
    private static final CustomRiderRendererManager INSTANCE = new CustomRiderRendererManager();
    private Set<EntityType<?>> types;

    public static CustomRiderRendererManager getInstance() {
        return INSTANCE;
    }

    public boolean hasRiderLayerRenderer(EntityType<?> type) {
        return this.types.contains(type);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        Map<EntityType<?>, EntityRenderer<?>> renderers = EntityRenderDispatcherAccess.getAllRenders();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<EntityType<?>, EntityRenderer<?>> entry : renderers.entrySet()) {
            EntityRenderer<?> entityRenderer = entry.getValue();
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer lR = (LivingEntityRenderer)entityRenderer;
            for (Object e : ((LivingEntityRendererAccessor)lR).getLayers()) {
                if (!(e instanceof RiderEntityLayer)) continue;
                builder.add(entry.getKey());
            }
        }
        this.types = builder.build();
    }
}

