/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderUtils {
    public static final int DEFAULT_COLOR = -1;
    private static final float TRIANGLE_MULT = (float)(Math.sqrt(3.0) / 2.0);
    private static final Random RANDOM = new Random(432L);

    public static float getPartialTicks() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
    }

    public static float getPartialTicks(Entity entity) {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(!entity.level().tickRateManager().isEntityFrozen(entity));
    }

    public static void renderBlockOutline(PoseStack poseStack, MultiBufferSource buffer, Player player, BlockPos pos, float partialTicks, boolean drawImmediately) {
        RenderUtils.renderBlockOutline(poseStack, buffer, player, pos, partialTicks, 0.0f, 0.0f, 0.0f, 1.0f, drawImmediately);
    }

    public static void renderBlockOutline(PoseStack poseStack, MultiBufferSource buffer, Player player, BlockPos pos, float partialTicks, float red, float green, float blue, float alpha, boolean drawImmediately) {
        BlockState state = player.level().getBlockState(pos);
        RenderType renderType = RenderType.lines();
        Vec3 vec = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        RenderUtils.renderShape(poseStack, buffer.getBuffer(renderType), state.getShape((BlockGetter)player.level(), pos, CollisionContext.of((Entity)player)), (double)pos.getX() - vec.x, (double)pos.getY() - vec.y, (double)pos.getZ() - vec.z, red, green, blue, alpha);
        if (drawImmediately && buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).endBatch(renderType);
        }
    }

    public static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = poseStack.last();
        shape.forAllEdges((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.sqrt((float)(q * q + r * r + s * s));
            consumer.addVertex(pose.pose(), (float)(k + x), (float)(l + y), (float)(m + z)).setColor(red, green, blue, alpha).setNormal(pose, q /= t, r /= t, s /= t);
            consumer.addVertex(pose.pose(), (float)(n + x), (float)(o + y), (float)(p + z)).setColor(red, green, blue, alpha).setNormal(pose, q, r, s);
        });
    }

    public static void renderAreaAround(PoseStack poseStack, MultiBufferSource buffer, BlockPos pos, float radius, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(poseStack, buffer, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).inflate((double)radius).move(pos.below()), drawImmediately);
    }

    public static void renderAreaAround(PoseStack poseStack, MultiBufferSource buffer, BlockPos pos, float radius, float red, float green, float blue, float alpha, boolean ignoreDepth, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(poseStack, buffer, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).inflate((double)radius).move(pos.below()), red, green, blue, alpha, drawImmediately);
    }

    public static void renderBoundingBox(PoseStack poseStack, MultiBufferSource buffer, AABB aabb, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(poseStack, buffer, aabb, 1.0f, 0.5f, 0.5f, 1.0f, drawImmediately);
    }

    public static void renderBoundingBox(PoseStack poseStack, MultiBufferSource buffer, AABB aabb, float red, float green, float blue, float alpha, boolean drawImmediately) {
        Vec3 vec = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        RenderType renderType = RenderType.lines();
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(renderType), (AABB)aabb.inflate(0.002).move(-vec.x, -vec.y, -vec.z), (float)red, (float)green, (float)blue, (float)alpha);
        if (drawImmediately && buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).endBatch();
        }
    }

    public static void renderOBB(PoseStack stack, MultiBufferSource buffer, OrientedBoundingBox obb, float red, float green, float blue, float alpha, boolean drawImmediately) {
        Vec3 second;
        Vec3 first;
        int b;
        Vec3 vec = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        stack.pushPose();
        stack.translate(-vec.x, -vec.y, -vec.z);
        RenderType renderType = RenderType.lines();
        VertexConsumer consumer = buffer.getBuffer(renderType);
        PoseStack.Pose pose = stack.last();
        for (b = 0; b < 4; ++b) {
            first = obb.getVertices()[b];
            second = obb.getVertices()[(b + 1) % 4];
            consumer.addVertex(pose, (float)first.x(), (float)first.y(), (float)first.z()).setColor(red, green, blue, alpha).setNormal(pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(pose, (float)second.x(), (float)second.y(), (float)second.z()).setColor(red, green, blue, alpha).setNormal(pose, 1.0f, 0.0f, 0.0f);
            Vec3 top = obb.getVertices()[4 + b];
            consumer.addVertex(pose, (float)first.x(), (float)first.y(), (float)first.z()).setColor(red, green, blue, alpha).setNormal(pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(pose, (float)top.x(), (float)top.y(), (float)top.z()).setColor(red, green, blue, alpha).setNormal(pose, 1.0f, 0.0f, 0.0f);
        }
        for (b = 4; b < 8; ++b) {
            first = obb.getVertices()[b];
            second = obb.getVertices()[4 + (b + 1) % 4];
            consumer.addVertex(pose, (float)first.x(), (float)first.y(), (float)first.z()).setColor(red, green, blue, alpha).setNormal(pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(pose, (float)second.x(), (float)second.y(), (float)second.z()).setColor(red, green, blue, alpha).setNormal(pose, 1.0f, 0.0f, 0.0f);
        }
        if (drawImmediately && buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).endBatch();
        }
        stack.popPose();
    }

    public static void applyYawPitch(PoseStack stack, float yaw, float pitch) {
        stack.mulPose(Axis.YP.rotationDegrees(yaw));
        stack.mulPose(Axis.ZP.rotationDegrees(pitch));
    }

    public static void renderTexture(PoseStack stack, VertexConsumer builder, float xSize, float ySize, TextureBuilder textureBuilder) {
        Matrix4f matrix4f = stack.last().pose();
        PoseStack.Pose pose = stack.last();
        builder.addVertex(matrix4f, -(xSize /= 2.0f), ySize /= 2.0f, 0.0f).setColor(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).setUv(textureBuilder.u, textureBuilder.v).setOverlay(textureBuilder.overlay).setLight(textureBuilder.light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, xSize, ySize, 0.0f).setColor(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).setUv(textureBuilder.u + textureBuilder.uLength, textureBuilder.v).setOverlay(textureBuilder.overlay).setLight(textureBuilder.light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, xSize, -ySize, 0.0f).setColor(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).setUv(textureBuilder.u + textureBuilder.uLength, textureBuilder.v + textureBuilder.vLength).setOverlay(textureBuilder.overlay).setLight(textureBuilder.light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, -xSize, -ySize, 0.0f).setColor(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).setUv(textureBuilder.u, textureBuilder.v + textureBuilder.vLength).setOverlay(textureBuilder.overlay).setLight(textureBuilder.light).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    public static void renderGradientBeams3d(PoseStack stack, MultiBufferSource renderTypeBuffer, float length, float width, int ticks, float partialTicks, float rotationPerTick, int amount, BeamBuilder builder) {
        stack.pushPose();
        RANDOM.setSeed(432L);
        for (int i = 0; i < amount; ++i) {
            float ticker = (float)ticks + partialTicks;
            stack.mulPose(Axis.XP.rotationDegrees(RANDOM.nextFloat() * 360.0f));
            stack.mulPose(Axis.YP.rotationDegrees(RANDOM.nextFloat() * 360.0f));
            stack.mulPose(Axis.ZP.rotationDegrees(RANDOM.nextFloat() * 360.0f + ticker * rotationPerTick));
            RenderUtils.renderGradientBeam3d(stack, renderTypeBuffer, length, width, builder);
        }
        stack.popPose();
    }

    public static void renderGradientBeam3d(PoseStack stack, MultiBufferSource renderTypeBuffer, float length, float width, BeamBuilder builder) {
        float heightHalf = TRIANGLE_MULT * width * 0.5f;
        float widthHalf = width * 0.5f;
        Matrix4f matrix4f = stack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(builder.renderType);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, -widthHalf, length, -heightHalf).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, widthHalf, length, -heightHalf).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, widthHalf, length, -heightHalf).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, 0.0f, length, heightHalf).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, 0.0f, length, heightHalf).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, -widthHalf, length, -heightHalf).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
    }

    public static void renderGradientBeams(PoseStack poseStack, MultiBufferSource renderTypeBuffer, float length, float width, int ticks, float partialTicks, float rotationPerTick, int amount, BeamBuilder builder) {
        poseStack.pushPose();
        RANDOM.setSeed(432L);
        for (int i = 0; i < amount; ++i) {
            float ticker = (float)ticks + partialTicks;
            poseStack.mulPose(Axis.XP.rotationDegrees(RANDOM.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(RANDOM.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(RANDOM.nextFloat() * 360.0f + ticker * rotationPerTick));
            RenderUtils.renderGradientBeam(poseStack, renderTypeBuffer, length, width, builder);
        }
        poseStack.popPose();
    }

    public static void renderGradientBeam(PoseStack poseStack, MultiBufferSource renderTypeBuffer, float length, float width, BeamBuilder builder) {
        float widthHalf = width * 0.5f;
        Matrix4f matrix4f = poseStack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(builder.renderType);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, -widthHalf, length, 0.0f).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, widthHalf, length, 0.0f).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(builder.red, builder.green, builder.blue, builder.alpha);
        buffer.addVertex(matrix4f, widthHalf, length, 0.0f).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
        buffer.addVertex(matrix4f, -widthHalf, length, 0.0f).setColor(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha);
    }

    public static void renderScaledEntityGui(GuiGraphics guiGraphics, float x, float y, float sizeX, float sizeY, float scale, float yOffset, float mouseX, float mouseY, LivingEntity entity) {
        float maxSizeWidth = sizeX / scale;
        float maxSizeHeight = sizeY / scale;
        float scaleMult = 1.0f;
        if (entity.getBbWidth() > maxSizeWidth) {
            scaleMult = maxSizeWidth / entity.getBbWidth();
        }
        if (entity.getBbHeight() > maxSizeHeight) {
            scaleMult = Math.min(scaleMult, maxSizeHeight / entity.getBbHeight());
        }
        RenderUtils.renderEntityMouseNoClip(guiGraphics, x, y, x + sizeX, y + sizeY, scale * scaleMult, yOffset, mouseX, mouseY, entity);
    }

    private static void renderEntityMouseNoClip(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float scale, float yOffset, float mouseX, float mouseY, LivingEntity entity) {
        float xM = (x1 + x2) / 2.0f;
        float yM = (y1 + y2) / 2.0f;
        float yRot = (float)Math.atan((xM - mouseX) / 40.0f);
        float xRot = (float)Math.atan((yM - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(xRot * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float preYBody = entity.yBodyRot;
        float preYRot = entity.getYRot();
        float preXRot = entity.getXRot();
        float preYHead0 = entity.yHeadRotO;
        float preYHead = entity.yHeadRot;
        entity.yBodyRot = 180.0f + yRot * 20.0f;
        entity.setYRot(180.0f + yRot * 40.0f);
        entity.setXRot(-xRot * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        float entityScale = entity.getScale();
        Vector3f offset = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + yOffset * entityScale, 0.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)xM, (float)yM, (float)scale, (Vector3f)offset, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (LivingEntity)entity);
        entity.yBodyRot = preYBody;
        entity.setYRot(preYRot);
        entity.setXRot(preXRot);
        entity.yHeadRotO = preYHead0;
        entity.yHeadRot = preYHead;
    }

    public static class TextureBuilder {
        private int red = 255;
        private int green = 255;
        private int blue = 255;
        private int alpha = 255;
        private float u;
        private float v;
        private float uLength = 1.0f;
        private float vLength = 1.0f;
        private int light = 0xF000F0;
        private int overlay = OverlayTexture.NO_OVERLAY;

        public void setUV(float u, float v) {
            this.u = u;
            this.v = v;
        }

        public void setUVLength(float uLength, float vLength) {
            this.uLength = uLength;
            this.vLength = vLength;
        }

        public void setColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setColor(red, green, blue, alpha);
        }

        public void setColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void setColor(float red, float green, float blue, float alpha) {
            this.setColor((int)red * 255, (int)green * 255, (int)blue * 255, (int)alpha * 255);
        }

        public void setOverlay(int overlay) {
            this.overlay = overlay;
        }

        public void setLight(int light) {
            this.light = light;
        }
    }

    public static class BeamBuilder {
        private int red = 255;
        private int green = 255;
        private int blue = 255;
        private int alpha = 255;
        private int endRed = 255;
        private int endGreen = 0;
        private int endBlue = 255;
        private int endAlpha = 0;
        private RenderType renderType = RenderType.lightning();

        public void setStartColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setStartColor(red, green, blue, alpha);
        }

        public void setStartColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void setEndColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setEndColor(red, green, blue, alpha);
        }

        public void setEndColor(int red, int green, int blue, int alpha) {
            this.endRed = red;
            this.endGreen = green;
            this.endBlue = blue;
            this.endAlpha = alpha;
        }

        public void setRenderType(RenderType renderType) {
            this.renderType = renderType;
        }
    }
}

