/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MultiPartEntity
extends Entity
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.defineId(MultiPartEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Float> SIZE_X = SynchedEntityData.defineId(MultiPartEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> SIZE_Y = SynchedEntityData.defineId(MultiPartEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private LivingEntity parent;
    private boolean addedToLevel;
    private boolean isHead;
    private MultipartPosition relativePosition = MultipartPosition.DEFAULT;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;

    public MultiPartEntity(EntityType<? extends MultiPartEntity> multipartType, Level level) {
        super(multipartType, level);
    }

    public MultiPartEntity(EntityType<? extends MultiPartEntity> multipartType, LivingEntity parent, float width, float height) {
        this(multipartType, parent.level());
        this.setSize(width, height);
        this.setParent(parent);
    }

    public void setParent(LivingEntity parent) {
        this.entityData.set(PARENT_UUID, Optional.of(parent.getUUID()));
        this.parent = parent;
    }

    public MultiPartEntity setHeadPart() {
        this.isHead = true;
        return this;
    }

    public MultiPartEntity setSizeX(float x) {
        this.setSize(x, ((Float)this.entityData.get(SIZE_Y)).floatValue());
        return this;
    }

    public MultiPartEntity setSizeY(float y) {
        this.setSize(((Float)this.entityData.get(SIZE_X)).floatValue(), y);
        return this;
    }

    public MultiPartEntity setSize(float x, float y) {
        if (!this.level().isClientSide) {
            this.entityData.set(SIZE_X, (Object)Float.valueOf(x));
            this.entityData.set(SIZE_Y, (Object)Float.valueOf(y));
        }
        this.refreshDimensions();
        return this;
    }

    public MultiPartEntity updatePosition(Vec3 relativePosition) {
        return this.updatePosition(new MultipartPosition(relativePosition));
    }

    public MultiPartEntity updatePosition(MultipartPosition relativePosition) {
        this.relativePosition = relativePosition;
        return this;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PARENT_UUID, Optional.empty());
        builder.define(SIZE_X, (Object)Float.valueOf(0.0f));
        builder.define(SIZE_Y, (Object)Float.valueOf(0.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SIZE_Y.equals(key)) {
            this.setSize(((Float)this.entityData.get(SIZE_X)).floatValue(), ((Float)this.entityData.get(SIZE_Y)).floatValue());
        }
    }

    protected MultipartPosition relativePosition() {
        return this.relativePosition;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.getDefaultDimensions().scale(this.getOwner() != null ? this.getOwner().getScale() : 1.0f);
    }

    protected EntityDimensions getDefaultDimensions() {
        float ageScale = this.getOwner() != null ? this.getOwner().getAgeScale() : 1.0f;
        return EntityDimensions.scalable((float)(ageScale * ((Float)this.entityData.get(SIZE_X)).floatValue()), (float)(ageScale * ((Float)this.entityData.get(SIZE_Y)).floatValue()));
    }

    public Component getName() {
        LivingEntity owner = this.getOwner();
        return owner != null ? owner.getName() : super.getName();
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public void tick() {
        if (!(this.level().isClientSide || this.getOwner() != null && this.getOwner().isAlive())) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        super.tick();
    }

    public void baseTick() {
        this.level().getProfiler().push("entityBaseTick");
        this.ejectPassengers();
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.clearFire();
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide) {
            this.updatePosition();
        }
        this.handleLerp();
        this.firstTick = false;
        this.level().getProfiler().pop();
    }

    protected void updatePosition() {
        Vec3 newPos = this.getOwner().position().add(this.relativePosition.getPosition(this.getOwner()));
        this.moveTo(newPos.x(), newPos.y(), newPos.z(), this.relativePosition.noPhysics());
    }

    protected void handleLerp() {
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = steps;
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    protected void moveTo(double x, double y, double z, boolean simple) {
        if (this.getOwner() != null && !this.isEntityAddedToLevel()) {
            this.setPos(x, y, z);
            this.level().addFreshEntity((Entity)this);
        }
        Vec3 old = this.position();
        this.setOldPosAndRot();
        if (simple) {
            this.setPos(x, y, z);
        } else {
            this.setOnGround(true);
            double vy = y - old.y;
            if (vy >= 0.0 && vy < 1.5) {
                vy = vy <= 1.0 ? -0.08 : 0.0;
            }
            this.move(MoverType.SELF, new Vec3(x - old.x, vy, z - old.z));
        }
    }

    public boolean parentTick() {
        if (this.getOwner() != null && !this.getOwner().level().isClientSide && !this.isEntityAddedToLevel()) {
            this.setPos(this.getOwner().position());
            this.level().addFreshEntity((Entity)this);
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return this.getOwner() != null && this.getOwner().hurt(source, amount);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return this.getOwner() != null ? this.getOwner().interact(player, hand) : InteractionResult.PASS;
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.getOwner() != null && this.getOwner().isInvulnerableTo(source)) {
            return true;
        }
        return source.is(DamageTypeTags.IS_FALL) || source.is(DamageTypeTags.IS_DROWNING) || !this.isHead && source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    public boolean isOnFire() {
        return this.getOwner() != null && this.getOwner().isOnFire();
    }

    public int getTicksFrozen() {
        return this.getOwner() != null ? this.getOwner().getTicksFrozen() : 0;
    }

    public boolean isPickable() {
        return this.getOwner() != null;
    }

    public ItemStack getPickResult() {
        return this.getOwner() != null ? this.getOwner().getPickResult() : null;
    }

    public void setLevelCallback(EntityInLevelCallback entityInLevelCallback) {
        super.setLevelCallback(entityInLevelCallback);
        this.addedToLevel = true;
    }

    public boolean isEntityAddedToLevel() {
        return this.addedToLevel;
    }

    public boolean isNoGravity() {
        return true;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(PARENT_UUID)).orElse(null);
    }

    public LivingEntity getOwner() {
        if (this.parent != null && this.parent.isAlive()) {
            return this.parent;
        }
        ((Optional)this.entityData.get(PARENT_UUID)).ifPresent(uuid -> {
            this.parent = EntityUtils.findFromUUID(LivingEntity.class, this.level(), uuid);
        });
        return this.parent;
    }

    public record MultipartPosition(Vec3 relative, PositionUpdater updater, boolean noPhysics) {
        public static final MultipartPosition DEFAULT = new MultipartPosition(Vec3.ZERO);

        public MultipartPosition(Vec3 relative) {
            this(relative, PositionUpdater.FROM_YROT, true);
        }

        public MultipartPosition(Vec3 relative, boolean noPhysics) {
            this(relative, PositionUpdater.FROM_YROT, noPhysics);
        }

        public Vec3 getPosition(LivingEntity parent) {
            return this.updater().from(this.relative(), parent);
        }
    }

    static interface PositionUpdater {
        public static final PositionUpdater FROM_YROT = (relative, parent) -> relative.yRot(-parent.yBodyRot * ((float)Math.PI / 180));

        public Vec3 from(Vec3 var1, LivingEntity var2);
    }
}

