/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.CircleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class CircleAround<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = MemoryTest.builder((int)1).hasMemory((MemoryModuleType)TenshilibMemoryModules.CIRCLE_DATA.get());

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return this.verifyTracker(entity);
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.verifyTracker(entity);
    }

    protected void tick(E entity) {
        BrainUtils.withMemory(entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.CIRCLE_DATA.get()), data -> this.circleAround(entity, (CircleData)data));
    }

    public void circleAround(E entity, CircleData data) {
        Vec3 pos = data.position().currentPosition();
        Vec3 dir = entity.position().subtract(pos.x(), entity.position().y(), pos.z()).normalize().scale((double)data.radius());
        dir = dir.yRot((float)(data.clockWise() ? 20 : -20) * ((float)Math.PI / 180));
        entity.getNavigation().moveTo(pos.x() + dir.x(), entity.getY(), pos.z() + dir.z(), 1.0);
    }

    protected boolean verifyTracker(E entity) {
        EntityTracker entityTracker;
        PositionTracker positionTracker;
        CircleData center = (CircleData)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.CIRCLE_DATA.get()));
        if (center == null || (positionTracker = center.position()) instanceof EntityTracker && !(entityTracker = (EntityTracker)positionTracker).getEntity().isAlive()) {
            if (center == null) {
                BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.CIRCLE_DATA.get()));
            }
            return false;
        }
        return true;
    }
}

