/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetWithinDist<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)3).hasMemory(MemoryModuleType.ATTACK_TARGET).usesMemories(new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET});
    protected double min = 1.0;
    protected double max = 10.0;
    protected BiFunction<E, LivingEntity, Float> speedMod = (owner, target) -> Float.valueOf(1.0f);

    public SetWalkTargetWithinDist<E> speedMod(float speedModifier) {
        return this.speedMod((owner, target) -> Float.valueOf(speedModifier));
    }

    public SetWalkTargetWithinDist<E> speedMod(BiFunction<E, LivingEntity, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public SetWalkTargetWithinDist<E> min(double min) {
        this.min = min;
        return this;
    }

    public SetWalkTargetWithinDist<E> max(double max) {
        this.max = max;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        Brain brain = entity.getBrain();
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        double distSqr = entity.distanceToSqr((Entity)target);
        if (!entity.getSensing().hasLineOfSight((Entity)target) || distSqr >= this.max * this.max) {
            int close = Mth.floor((double)Math.max(this.min, this.max - 2.0));
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), this.speedMod.apply(entity, target).floatValue(), close));
        } else if (distSqr <= this.min * this.min) {
            int range = Mth.ceil((double)(this.max - Math.sqrt(distSqr)));
            for (int i = 0; i < 10; ++i) {
                Vec3 posAway = DefaultRandomPos.getPosAway(entity, (int)range, (int)range, (Vec3)target.position());
                if (posAway == null) continue;
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(posAway, this.speedMod.apply(entity, target).floatValue(), 0));
                break;
            }
        } else {
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
        }
    }
}

