/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.animated;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.DoubleStream;
import net.minecraft.util.ExtraCodecs;

public class AnimationsBuilder {
    public static final Codec<AnimationsBuilder> CODEC = Codec.unboundedMap((Codec)Codec.STRING, DefinitionBuilder.CODEC).xmap(m -> {
        AnimationsBuilder builder = new AnimationsBuilder();
        builder.definitions.putAll((Map<String, DefinitionBuilder>)m);
        return builder;
    }, builder -> builder.definitions);
    private final Map<String, DefinitionBuilder> definitions = new HashMap<String, DefinitionBuilder>();
    private boolean built;

    public AnimationsBuilder() {
    }

    public AnimationsBuilder(AnimationsBuilder source, String ... include) {
        for (String id : include) {
            this.add(source, id);
        }
    }

    public static DefinitionBuilder definition(double length) {
        return AnimationsBuilder.definition(length, true);
    }

    public static DefinitionBuilder definition(double length, boolean seconds) {
        return new DefinitionBuilder(seconds ? length * 20.0 : length);
    }

    public String add(String id, DefinitionBuilder builder) {
        if (this.built) {
            throw new IllegalStateException("Builder has already been built!");
        }
        this.definitions.put(id, builder);
        return id;
    }

    public String add(String id, String copyOf) {
        if (this.built) {
            throw new IllegalStateException("Builder has already been built!");
        }
        this.definitions.put(id, this.definitions.get(copyOf).copy(copyOf));
        return id;
    }

    public String add(AnimationsBuilder source, String id) {
        if (this.built) {
            throw new IllegalStateException("Builder has already been built!");
        }
        DefinitionBuilder definition = source.definitions.get(id);
        if (definition == null) {
            throw new IllegalStateException("Source has no definition with id " + id);
        }
        this.definitions.put(id, definition);
        return id;
    }

    public AnimationDefinitionContainer build() {
        this.built = true;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.definitions.forEach((id, def) -> {
            AnimationDefinition definition = def.build((String)id);
            builder.put((Object)definition.id(), (Object)definition);
        });
        return new AnimationDefinitionContainer((Map<String, AnimationDefinition>)builder.build());
    }

    public static class DefinitionBuilder {
        public static final Codec<DefinitionBuilder> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("animation").forGetter(d -> d.animation.isEmpty() ? Optional.empty() : Optional.of(d.animation)), (App)Codec.DOUBLE.fieldOf("length").forGetter(d -> d.length), (App)Codec.DOUBLE.optionalFieldOf("speed").forGetter(d -> d.speed == 1.0 ? Optional.empty() : Optional.of(d.speed)), (App)Codec.BOOL.optionalFieldOf("should_run_out").forGetter(d -> d.shouldRunOut ? Optional.empty() : Optional.of(false)), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("start_transition").forGetter(d -> d.defaultStartTransition == 0 ? Optional.empty() : Optional.of(d.defaultStartTransition)), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("end_transition").forGetter(d -> d.defaultEndTransition == 3 ? Optional.empty() : Optional.of(d.defaultEndTransition)), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE.listOf()).optionalFieldOf("markers").forGetter(d -> d.marker.isEmpty() ? Optional.empty() : Optional.of(DefinitionBuilder.asListMap(d.marker)))).apply((Applicative)inst, (animation, length, speed, runOut, startTrans, endTrans, markers) -> {
            DefinitionBuilder builder = new DefinitionBuilder((double)length).animationId(animation.orElse("")).speed(speed.orElse(1.0)).withTransitionTime(startTrans.orElse(0), endTrans.orElse(3));
            if (!runOut.orElse(true).booleanValue()) {
                builder.infinite();
            }
            markers.ifPresent(m -> m.forEach((s, ds) -> builder.marker((String)s, ds.stream().mapToDouble(d -> d).toArray())));
            return builder;
        }));
        private final double length;
        private String animation = "";
        private double speed = 1.0;
        private boolean shouldRunOut = true;
        private int defaultStartTransition;
        private int defaultEndTransition = 3;
        private final Map<String, double[]> marker = new HashMap<String, double[]>();

        private DefinitionBuilder(double length) {
            this.length = Math.max(1.0, length);
        }

        private static Map<String, List<Double>> asListMap(Map<String, double[]> markers) {
            HashMap<String, List<Double>> map = new HashMap<String, List<Double>>();
            markers.forEach((s, ds) -> map.put((String)s, DoubleStream.of(ds).boxed().toList()));
            return map;
        }

        public DefinitionBuilder animationId(String animation) {
            this.animation = animation;
            return this;
        }

        public DefinitionBuilder speed(double speed) {
            this.speed = speed;
            return this;
        }

        public DefinitionBuilder infinite() {
            this.shouldRunOut = false;
            return this;
        }

        public DefinitionBuilder withTransitionTime(int start, int end) {
            this.defaultStartTransition = start;
            this.defaultEndTransition = end;
            return this;
        }

        public DefinitionBuilder marker(String identifier, double ... time) {
            this.marker.put(identifier, time);
            return this;
        }

        public DefinitionBuilder copy(String animation) {
            DefinitionBuilder copy = new DefinitionBuilder(this.length).animationId(this.animation.isEmpty() ? animation : this.animation).speed(this.speed).withTransitionTime(this.defaultStartTransition, this.defaultEndTransition);
            copy.shouldRunOut = this.shouldRunOut;
            copy.marker.putAll(this.marker);
            return copy;
        }

        public AnimationDefinition build(String id) {
            return new AnimationDefinition(id, this.animation.isEmpty() ? id : this.animation, this.length, this.speed, this.shouldRunOut, this.defaultStartTransition, this.defaultEndTransition, (Map<String, double[]>)ImmutableMap.copyOf(this.marker));
        }
    }
}

