/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ArrayUtils {
    public static <T> String arrayToString(T[] t, @Nullable Function<T, String> parser) {
        if (t == null || t.length == 0) {
            return "";
        }
        if (parser == null) {
            parser = Object::toString;
        }
        StringBuilder s = new StringBuilder(t[0] == null ? "" : parser.apply(t[0]));
        if (t.length == 1) {
            return s.toString();
        }
        for (int i = 1; i < t.length; ++i) {
            s.append(",").append(t[i] == null ? "NULL" : parser.apply(t[i]));
        }
        return s.toString();
    }

    public static <T, M> M[] arrayConverter(T[] ts, Function<T, M> parser, Class<M> clss) {
        return ArrayUtils.arrayConverter(ts, parser, clss, false);
    }

    public static <T, M> M[] arrayConverter(T[] ts, Function<T, M> parser, Class<M> clss, boolean allowNullReturn) {
        return ArrayUtils.arrayConverter(ts, parser, clss, false, false);
    }

    public static <T, M> M[] arrayConverter(T[] ts, Function<T, M> parser, Class<M> clss, boolean allowNullReturn, boolean allowNullValue) {
        if (allowNullReturn && ts == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        if (ts != null) {
            for (T t : ts) {
                if (!allowNullValue && t == null) continue;
                list.add(t == null ? null : (Object)parser.apply(t));
            }
        }
        Object[] ms = (Object[])Array.newInstance(clss, list.size());
        for (int i = 0; i < ms.length; ++i) {
            ms[i] = list.get(i);
        }
        return ms;
    }
}

