/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.util.List;
import java.util.function.ToIntFunction;

public class SearchUtils {
    public static <T> T searchInfFunc(List<T> l, ToIntFunction<T> search, T defaultVal) {
        if (l.isEmpty() || search.applyAsInt(l.getFirst()) > 0) {
            return defaultVal;
        }
        return (T)SearchUtils.get(l, 0, l.size(), search);
    }

    public static <T extends Comparable<T>> T searchInf(List<T> l, T search, T defaultVal) {
        if (l.isEmpty() || ((Comparable)l.getFirst()).compareTo(search) > 0) {
            return defaultVal;
        }
        return SearchUtils.get(l, 0, l.size(), search);
    }

    public static <T extends Comparable<T>> T searchInf(T[] arr, T search, T defaultVal) {
        if (arr.length == 0 || arr[0].compareTo(search) > 0) {
            return defaultVal;
        }
        return (T)SearchUtils.get(arr, (int)0, (int)arr.length, search);
    }

    private static <T> T get(List<T> l, int min, int max, ToIntFunction<T> search) {
        int id = (max - min) / 2 + min;
        T val = l.get(id);
        if (search.applyAsInt(val) == 0) {
            return val;
        }
        if (search.applyAsInt(val) < 0) {
            if (id + 1 >= l.size() || search.applyAsInt(l.get(id + 1)) > 0) {
                return val;
            }
            return (T)SearchUtils.get(l, id, max, search);
        }
        return (T)SearchUtils.get(l, min, id, search);
    }

    private static <T extends Comparable<T>> T get(List<T> l, int min, int max, T search) {
        int id = (max - min) / 2 + min;
        Comparable val = (Comparable)l.get(id);
        if (val.compareTo(search) == 0) {
            return (T)val;
        }
        if (val.compareTo(search) < 0) {
            if (id + 1 >= l.size() || ((Comparable)l.get(id + 1)).compareTo(search) > 0) {
                return (T)val;
            }
            return SearchUtils.get(l, id, max, search);
        }
        return SearchUtils.get(l, min, id, search);
    }

    private static <T extends Comparable<T>> T get(T[] arr, int min, int max, T search) {
        int id = (max - min) / 2 + min;
        T val = arr[id];
        if (val.compareTo(search) == 0) {
            return val;
        }
        if (val.compareTo(search) < 0) {
            if (id + 1 >= arr.length || arr[id + 1].compareTo(search) > 0) {
                return val;
            }
            return (T)SearchUtils.get(arr, (int)id, (int)max, search);
        }
        return (T)SearchUtils.get(arr, (int)min, (int)id, search);
    }
}

