/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MathUtils {
    public static final Vec3 NORMAL_X = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 NORMAL_Y = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 NORMAL_Z = new Vec3(0.0, 0.0, 1.0);

    public static double[] closestOnCircle(double centerX, double centerY, double pointX, double pointY, double radius) {
        double x = pointX - centerX;
        double y = pointY - centerY;
        double d0 = Math.sqrt(x * x + y * y);
        return new double[]{x / d0 * radius + centerX, y / d0 * radius + centerY};
    }

    public static List<float[]> pointsOfCircle(float radius, int density) {
        float rad = (float)density * ((float)Math.PI / 180);
        float i = -rad;
        ArrayList<float[]> list = new ArrayList<float[]>();
        while ((double)i < Math.PI * 2) {
            list.add(new float[]{radius * Mth.cos((float)(i += rad)), radius * Mth.sin((float)i)});
        }
        return list;
    }

    public static List<Vector3f> rotatedVecs(Vector3f dir, Vector3f axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        list.add(new Vector3f((Vector3fc)dir));
        for (y = step; y <= maxDeg; y += step) {
            list.add(dir.rotateAxis(y * ((float)Math.PI / 180), axis.x(), axis.y(), axis.z(), new Vector3f()));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(dir.rotateAxis(y * ((float)Math.PI / 180), axis.x(), axis.y(), axis.z(), new Vector3f()));
        }
        return list;
    }

    public static List<Vector3d> rotatedVecs(Vector3d dir, Vector3d axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3d> list = new ArrayList<Vector3d>();
        list.add(new Vector3d((Vector3dc)dir));
        for (y = step; y <= maxDeg; y += step) {
            list.add(dir.rotateAxis((double)(y * ((float)Math.PI / 180)), axis.x(), axis.y(), axis.z(), new Vector3d()));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(dir.rotateAxis((double)(y * ((float)Math.PI / 180)), axis.x(), axis.y(), axis.z(), new Vector3d()));
        }
        return list;
    }

    public static Vec3 closestPointToLine(Vec3 point, Vec3 from, Vec3 dir) {
        if (dir.equals((Object)Vec3.ZERO)) {
            return from;
        }
        double lengthSq = dir.lengthSqr();
        double x = Math.max(0.0, Math.min(1.0, point.subtract(from).dot(dir) / lengthSq));
        return from.add(dir.scale(x));
    }

    public static double[] rotate2d(double x, double y, double angle) {
        return new double[]{x * Math.cos(angle) - y * Math.sin(angle), y * Math.cos(angle) + x * Math.sin(angle)};
    }

    public static double[][] createRegularPolygonPoints(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        double[][] res = new double[shape][];
        Vector3d base = new Vector3d((double)width, 0.0, 0.0);
        float rotatePer = 360.0f / (float)shape;
        if (shape % 2 == 0) {
            base = base.rotateAxis((double)(rotatePer * 0.5f * ((float)Math.PI / 180)), 0.0, 0.0, 1.0);
        }
        res[0] = new double[]{base.x, base.y};
        for (int i = 1; i < shape; ++i) {
            Vector3d rotated = base.rotateAxis((double)(rotatePer * (float)i * ((float)Math.PI / 180)), 0.0, 0.0, 1.0, new Vector3d());
            res[i] = new double[]{rotated.x, rotated.y};
        }
        return res;
    }

    public static float[][] createRegularPolygonPointsF(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        float[][] res = new float[shape][];
        Vector3f base = new Vector3f(width, 0.0f, 0.0f);
        float rotatePer = 360.0f / (float)shape;
        if (shape % 2 == 0) {
            base = base.rotateAxis(rotatePer * 0.5f * ((float)Math.PI / 180), 0.0f, 0.0f, 1.0f);
        }
        res[0] = new float[]{base.x, base.y};
        for (int i = 1; i < shape; ++i) {
            Vector3f rotated = base.rotateAxis(rotatePer * (float)i * ((float)Math.PI / 180), 0.0f, 0.0f, 1.0f, new Vector3f());
            res[i] = new float[]{rotated.x, rotated.y};
        }
        return res;
    }

    public static Pair<Vec3, Vec3> closestPointsAABB(AABB axisalignedbb, AABB axisalignedbb2) {
        Vec3 first = new Vec3(axisalignedbb.minX <= axisalignedbb2.minX ? axisalignedbb2.minX : (axisalignedbb.maxX >= axisalignedbb2.maxX ? axisalignedbb2.maxX : axisalignedbb.minX), axisalignedbb.minY <= axisalignedbb2.minY ? axisalignedbb2.minY : (axisalignedbb.maxY >= axisalignedbb2.maxY ? axisalignedbb2.maxY : axisalignedbb.minY), axisalignedbb.minZ <= axisalignedbb2.minZ ? axisalignedbb2.minZ : (axisalignedbb.maxZ >= axisalignedbb2.maxZ ? axisalignedbb2.maxZ : axisalignedbb.minZ));
        Vec3 second = new Vec3(axisalignedbb2.minX <= axisalignedbb.minX ? axisalignedbb.minX : (axisalignedbb2.maxX >= axisalignedbb.maxX ? axisalignedbb.maxX : axisalignedbb2.minX), axisalignedbb2.minY <= axisalignedbb.minY ? axisalignedbb.minY : (axisalignedbb2.maxY >= axisalignedbb.maxY ? axisalignedbb.maxY : axisalignedbb2.minY), axisalignedbb2.minZ <= axisalignedbb.minZ ? axisalignedbb.minZ : (axisalignedbb2.maxZ >= axisalignedbb.maxZ ? axisalignedbb.maxZ : axisalignedbb2.minZ));
        return Pair.of((Object)first, (Object)second);
    }

    public static double distTo(Entity e, Vec3 from, Vec3 to) {
        double d = Double.MAX_VALUE;
        Vec3 dir = to.subtract(from);
        for (double height = 0.0; height <= (double)e.getBbHeight(); height += (double)e.getBbHeight() * 0.1) {
            Vec3 point = e.position().add(0.0, height, 0.0);
            double nD = MathUtils.closestPointToLine(point, from, dir).distanceToSqr(point);
            if (!(nD < d)) continue;
            d = nD;
        }
        return d;
    }

    public static Vec3 farestPointToLine(Vec3 point, Vec3 l1, Vec3 dir) {
        return new Vec3(Math.abs(l1.x - point.x) > Math.abs(dir.x - point.x) ? l1.x : dir.x, Math.abs(l1.y - point.y) > Math.abs(dir.y - point.y) ? l1.y : dir.y, Math.abs(l1.z - point.z) > Math.abs(dir.z - point.z) ? l1.z : dir.z);
    }

    public static double roundTo(double val, double step) {
        return (double)Math.round(val / (double)((float)step)) * step;
    }
}

