/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.loader;

import io.github.flemmli97.tenshilib.TenshiLib;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class LoaderInitializer {
    public static <T> T getImplInstance(Class<T> abstractClss, String ... impls) {
        if (impls == null || impls.length == 0) {
            throw new IllegalStateException("Couldn't create an instance of " + String.valueOf(abstractClss) + ". No implementations provided!");
        }
        Class<?> clss = null;
        for (int i = 0; clss == null && i < impls.length; ++i) {
            try {
                clss = Class.forName(impls[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clss == null) {
            TenshiLib.LOGGER.fatal("No Implementation of {} found with given paths {}", abstractClss, (Object)Arrays.toString(impls));
        } else if (abstractClss.isAssignableFrom(clss)) {
            try {
                Constructor<?> constructor = clss.getDeclaredConstructor(new Class[0]);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                TenshiLib.LOGGER.fatal("Implementation of {} needs to provide an no arg constructor", clss);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                TenshiLib.LOGGER.fatal((Object)e);
            }
        }
        throw new IllegalStateException("Couldn't create an instance of " + String.valueOf(abstractClss));
    }
}

