/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.mixinhelper;

import io.github.flemmli97.tenshilib.TenshiLib;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public interface EntityRenderDispatcherAccess {
    public static Matrix4f toWorldMatrix(Matrix4f localMatrix) {
        Matrix4f preMatrix = ((EntityRenderDispatcherAccess)Minecraft.getInstance().getEntityRenderDispatcher()).tenshilib$getPreRenderMatrix();
        if (preMatrix == null) {
            TenshiLib.LOGGER.error("Trying to get world position from wrong/non render context!");
            return null;
        }
        preMatrix.invert();
        preMatrix.mul((Matrix4fc)localMatrix);
        return preMatrix;
    }

    public static Vec3 toWorldPosition(Entity entity, Matrix4f localMatrix) {
        Matrix4f preMatrix = EntityRenderDispatcherAccess.toWorldMatrix(localMatrix);
        if (preMatrix == null) {
            return entity.position();
        }
        Vector4f offset = preMatrix.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return entity.position().add((double)offset.x(), (double)offset.y(), (double)offset.z());
    }

    public static Map<EntityType<?>, EntityRenderer<?>> getAllRenders() {
        return ((EntityRenderDispatcherAccess)Minecraft.getInstance().getEntityRenderDispatcher()).tenshilib$getRenderers();
    }

    public Map<EntityType<?>, EntityRenderer<?>> tenshilib$getRenderers();

    public Matrix4f tenshilib$getPreRenderMatrix();
}

