/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ItemFilterComponent {
    public static final Codec<ItemFilterComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.orElse((Object)true).fieldOf("strict").forGetter(component -> component.strict), (App)ItemStack.OPTIONAL_CODEC.fieldOf("stack").forGetter(component -> component.stack)).apply((Applicative)instance, ItemFilterComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemFilterComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, component -> component.strict, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, component -> component.stack, ItemFilterComponent::new);
    public static final ItemFilterComponent EMPTY = new ItemFilterComponent(false, ItemStack.EMPTY);
    private final boolean strict;
    private final ItemStack stack;

    private ItemFilterComponent(boolean strict, ItemStack stack) {
        this.strict = strict;
        this.stack = stack;
    }

    public static ItemFilterComponent of(boolean strict, ItemStack stack) {
        return new ItemFilterComponent(strict, stack.copyWithCount(1));
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isPresent() {
        return !this.stack.isEmpty();
    }

    public ItemStack getStack() {
        return this.stack.copy();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Boolean.hashCode(this.strict);
        hash = 31 * hash + (this.stack == null ? 0 : ItemStack.hashItemAndComponents((ItemStack)this.stack));
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ItemFilterComponent other = (ItemFilterComponent)object;
        return this.strict == other.strict && (this.stack == other.stack || this.stack != null && other.stack != null && this.stack.isEmpty() == other.stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack));
    }
}

