/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class TagFilterComponent {
    public static final Codec<TagFilterComponent> CODEC = TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("tag").xmap(TagFilterComponent::new, tagMatchTest -> tagMatchTest.tag).codec();
    public static final StreamCodec<ByteBuf, TagFilterComponent> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(location -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location), TagKey::location).apply(ByteBufCodecs::optional).map(TagFilterComponent::new, component -> component.tag);
    public static final TagFilterComponent EMPTY = new TagFilterComponent(Optional.empty());
    private final Optional<TagKey<Item>> tag;

    private TagFilterComponent(Optional<TagKey<Item>> tag) {
        this.tag = tag;
    }

    public static TagFilterComponent of(TagKey<Item> tag) {
        return new TagFilterComponent(Optional.of(tag));
    }

    public static TagFilterComponent of(ResourceLocation tag) {
        return TagFilterComponent.of((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag));
    }

    public boolean isPresent() {
        return this.tag.isPresent();
    }

    public TagKey<Item> getTag() {
        return this.tag.get();
    }

    public int hashCode() {
        return Objects.hash(this.tag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TagFilterComponent other = (TagFilterComponent)obj;
        return Objects.equals(this.tag, other.tag);
    }
}

