/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.integration.jei;

import info.u_team.useful_backpacks.init.UsefulBackpacksItems;
import info.u_team.useful_backpacks.integration.jei.extension.BackpackCraftingRecipeCategoryExtension;
import info.u_team.useful_backpacks.recipe.BackpackCraftingRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class UsefulBackpacksJeiPlugin
implements IModPlugin {
    private final ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"usefulbackpacks", (String)"jei");

    public ResourceLocation getPluginUid() {
        return this.id;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ISubtypeInterpreter<ItemStack> interpreter = new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack stack, UidContext context) {
                if (context == UidContext.Ingredient) {
                    return stack.get(DataComponents.DYED_COLOR);
                }
                return null;
            }

            public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext context) {
                DyedItemColor color;
                if (context == UidContext.Ingredient && (color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR)) != null) {
                    return Integer.toString(color.rgb());
                }
                return "";
            }
        };
        registration.registerSubtypeInterpreter((Item)UsefulBackpacksItems.SMALL_BACKPACK.get(), (ISubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter((Item)UsefulBackpacksItems.MEDIUM_BACKPACK.get(), (ISubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter((Item)UsefulBackpacksItems.LARGE_BACKPACK.get(), (ISubtypeInterpreter)interpreter);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(BackpackCraftingRecipe.class, (ICraftingCategoryExtension)new BackpackCraftingRecipeCategoryExtension());
    }
}

