/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.integration.jei.extension;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.u_team_core.util.RGB;
import info.u_team.useful_backpacks.recipe.BackpackCraftingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BackpackCraftingRecipeCategoryExtension
implements ICraftingCategoryExtension<BackpackCraftingRecipe> {
    public int getWidth(RecipeHolder<BackpackCraftingRecipe> holder) {
        return ((BackpackCraftingRecipe)holder.value()).getWidth();
    }

    public int getHeight(RecipeHolder<BackpackCraftingRecipe> holder) {
        return ((BackpackCraftingRecipe)holder.value()).getHeight();
    }

    public void setRecipe(RecipeHolder<BackpackCraftingRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        BackpackCraftingRecipe recipe = (BackpackCraftingRecipe)holder.value();
        List inputs = recipe.getIngredients().stream().map(ingredient -> Lists.newArrayList((Object[])ingredient.getItems())).collect(Collectors.toCollection(ArrayList::new));
        ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())});
        AtomicBoolean changed = new AtomicBoolean(false);
        focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).findFirst().ifPresent(outputStack -> {
            DyedItemColor dyedColor = (DyedItemColor)outputStack.get(DataComponents.DYED_COLOR);
            if (dyedColor != null) {
                int dyeableColor = dyedColor.rgb();
                DyeColor color = ColorUtil.findClosestDyeColor((RGB)new RGB(dyeableColor));
                Block wool = ColorUtil.getWoolFromColor((DyeColor)color);
                for (int index = 0; index < inputs.size(); ++index) {
                    List list = (List)inputs.get(index);
                    if (!list.stream().allMatch(stack -> stack.is(ItemTags.WOOL))) continue;
                    if (dyeableColor != 8478784) {
                        inputs.set(index, List.of(new ItemStack((ItemLike)wool)));
                        continue;
                    }
                    inputs.set(index, List.of(new ItemStack((ItemLike)Blocks.WHITE_WOOL)));
                }
                outputs.set(0, DyedItemColor.applyDyes((ItemStack)((ItemStack)outputs.get(0)), List.of(DyeItem.byColor((DyeColor)color))));
                changed.set(true);
            }
        });
        focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).findFirst().ifPresent(inputStack -> {
            if (inputStack.is(ItemTags.WOOL)) {
                DyeColor color = ColorUtil.getColorFromWool((Item)inputStack.getItem());
                if (color != null && color != DyeColor.WHITE) {
                    outputs.set(0, DyedItemColor.applyDyes((ItemStack)((ItemStack)outputs.get(0)), List.of(DyeItem.byColor((DyeColor)color))));
                }
                changed.set(true);
            }
        });
        if (!changed.get()) {
            Stream.of(DyeColor.values()).map(color -> {
                if (color == DyeColor.WHITE) {
                    return (ItemStack)outputs.get(0);
                }
                return DyedItemColor.applyDyes((ItemStack)((ItemStack)outputs.get(0)), List.of(DyeItem.byColor((DyeColor)color)));
            }).forEach(outputs::add);
            outputs.remove(0);
        }
        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, this.getWidth(holder), this.getHeight(holder));
        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, (List)outputs);
    }
}

