/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.inventory;

import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DelegateInventory
implements Container {
    private final Container fallback;
    private Container inventory;

    public DelegateInventory(Container fallback) {
        this.fallback = fallback;
        this.inventory = fallback;
    }

    public void setInventory(Container inventory) {
        this.inventory = inventory;
        if (this.inventory == null) {
            this.inventory = this.fallback;
        }
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public void setChanged() {
        this.inventory.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void startOpen(Player player) {
        this.inventory.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.inventory.stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public int countItem(Item itemIn) {
        return this.inventory.countItem(itemIn);
    }

    public boolean hasAnyOf(Set<Item> set) {
        return this.inventory.hasAnyOf(set);
    }
}

