/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.api.Filter;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.component.TagFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.inventory.FilterInventory;
import info.u_team.useful_backpacks.item.ItemFilterItem;
import info.u_team.useful_backpacks.item.TagFilterItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public interface AutoPickupBackpack
extends Backpack {
    @Override
    default public boolean canAutoPickup(ItemStack stack, ItemStack backpackStack) {
        FilterInventory filterInventory = new FilterInventory(backpackStack);
        for (int index = 0; index < filterInventory.getContainerSize(); ++index) {
            Filter filter;
            ItemStack filterStack = filterInventory.getItem(index);
            Item filterItem = filterStack.getItem();
            if (!(filterItem instanceof Filter) || !(filter = (Filter)filterItem).matchItem(filterStack, stack)) continue;
            return true;
        }
        return false;
    }

    default public void addTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ArrayList<ItemStack> filters = new ArrayList<ItemStack>();
        FilterInventory filterInventory = new FilterInventory(stack);
        for (int index = 0; index < filterInventory.getContainerSize(); ++index) {
            ItemStack filterStack2 = filterInventory.getItem(index);
            if (!(filterStack2.getItem() instanceof Filter)) continue;
            filters.add(filterStack2);
        }
        if (!filters.isEmpty()) {
            tooltip.add((Component)TooltipCreator.create((String)"usefulbackpacks", (String)"backpack", (String)"filter", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC}));
            tooltip.add(CommonComponents.EMPTY);
            if (!flag.isAdvanced()) {
                tooltip.add((Component)TooltipCreator.create((String)"usefulbackpacks", (String)"backpack", (String)"filter_not_advanced", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
            } else {
                tooltip.add((Component)TooltipCreator.create((String)"usefulbackpacks", (String)"backpack", (String)"filter_applied", (int)0).withStyle(ChatFormatting.AQUA));
                filters.stream().filter(filterStack -> filterStack.getItem() instanceof ItemFilterItem).forEach(filterStack -> {
                    ItemFilterComponent itemComponent = (ItemFilterComponent)filterStack.get((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
                    if (itemComponent != null && itemComponent.isPresent()) {
                        MutableComponent component = TooltipCreator.create((String)"usefulbackpacks", (String)"backpack", (String)"filter_applied_item", (int)0, (Object[])new Object[]{Component.translatable((String)itemComponent.getStack().getDescriptionId()).withStyle(ChatFormatting.YELLOW)});
                        if (itemComponent.isStrict()) {
                            component.append(" ").append((Component)TooltipCreator.create((String)"usefulbackpacks", (String)"backpack", (String)"filter_applied_item", (int)1));
                        }
                        component.withStyle(ChatFormatting.GRAY);
                        tooltip.add((Component)component);
                    }
                });
                filters.stream().filter(filterStack -> filterStack.getItem() instanceof TagFilterItem).forEach(filterStack -> {
                    TagFilterComponent itemComponent = (TagFilterComponent)filterStack.get((DataComponentType)UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get());
                    if (itemComponent != null && itemComponent.isPresent()) {
                        MutableComponent component = TooltipCreator.create((String)"usefulbackpacks", (String)"backpack", (String)"filter_applied_tag", (int)0, (Object[])new Object[]{Component.literal((String)itemComponent.getTag().location().toString()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY);
                        tooltip.add((Component)component);
                    }
                });
            }
        }
    }
}

