/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.MenuUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.item.AutoPickupBackpack;
import info.u_team.useful_backpacks.menu.BackpackMenu;
import info.u_team.useful_backpacks.type.BackpackType;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class BackpackItem
extends UItem
implements AutoPickupBackpack {
    public static final int DEFAULT_COLOR = 8478784;
    private final BackpackType backpack;

    public BackpackItem(BackpackType backpack) {
        super(new Item.Properties().stacksTo(1).rarity(backpack.getRarity()).component((DataComponentType)UsefulBackpacksDataComponentTypes.BACKPACK_COMPONENT.get(), (Object)ItemContainerContents.EMPTY).component((DataComponentType)UsefulBackpacksDataComponentTypes.FILTER_COMPONENT.get(), (Object)ItemContainerContents.EMPTY));
        this.backpack = backpack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            this.open((ServerPlayer)player, stack, hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : -1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public void open(ServerPlayer player, ItemStack backpackStack, int selectedSlot) {
        MenuUtil.openMenu((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> new BackpackMenu(id, playerInventory, (Container)this.getInventory(player, backpackStack), this.backpack, selectedSlot), backpackStack.getHoverName()), buffer -> {
            buffer.writeEnum((Enum)this.backpack);
            buffer.writeVarInt(selectedSlot);
        }, (boolean)false);
    }

    @Override
    public SimpleContainer getInventory(ServerPlayer player, ItemStack backpackStack) {
        return new BackpackInventory(backpackStack, this.backpack.getInventorySize());
    }

    @Override
    public void saveInventory(SimpleContainer inventory, ItemStack backpackStack) {
        if (inventory instanceof BackpackInventory) {
            BackpackInventory backpackInventory = (BackpackInventory)inventory;
            backpackInventory.writeItemStack();
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        this.addTooltip(stack, context, tooltip, flag);
    }

    public BackpackType getBackpack() {
        return this.backpack;
    }

    public boolean shouldPlayUpdateAnimation(ItemStack oldStack, ItemStack newStack) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean canBeDropped(ItemStack stack, Player player) {
        return !(player.containerMenu instanceof BackpackMenu);
    }
}

