/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.MenuUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.item.AutoPickupBackpack;
import info.u_team.useful_backpacks.menu.EnderChestBackpackMenu;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class EnderChestBackpackItem
extends UItem
implements AutoPickupBackpack {
    public EnderChestBackpackItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).component((DataComponentType)UsefulBackpacksDataComponentTypes.FILTER_COMPONENT.get(), (Object)ItemContainerContents.EMPTY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.open(serverPlayer, stack, hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : -1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public void open(ServerPlayer player, ItemStack backpackStack, int selectedSlot) {
        MenuUtil.openMenu((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> EnderChestBackpackMenu.createEnderChestContainer(id, playerInventory, (Container)this.getInventory(player, backpackStack), selectedSlot), backpackStack.getHoverName()), buffer -> buffer.writeVarInt(selectedSlot), (boolean)false);
    }

    @Override
    public SimpleContainer getInventory(ServerPlayer player, ItemStack backpackStack) {
        return player.getEnderChestInventory();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        this.addTooltip(stack, context, tooltip, flag);
    }
}

