/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.util.MenuUtil;
import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.item.FilterItem;
import info.u_team.useful_backpacks.menu.ItemFilterMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemFilterItem
extends FilterItem {
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                stack.set((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get(), (Object)ItemFilterComponent.EMPTY);
            } else {
                int selectedSlot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : -1;
                ItemFilterComponent component = (ItemFilterComponent)stack.get((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
                boolean isStrict = component == null ? false : component.isStrict();
                MenuUtil.openMenu((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> new ItemFilterMenu(id, playerInventory, stack, selectedSlot, isStrict), stack.getHoverName()), buffer -> {
                    buffer.writeVarInt(selectedSlot);
                    buffer.writeBoolean(isStrict);
                }, (boolean)false);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    protected boolean matches(ItemStack filterStack, ItemStack matchStack) {
        ItemFilterComponent component = (ItemFilterComponent)filterStack.get((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
        boolean strict = component.isStrict();
        ItemStack stack = component.getStack();
        if (strict) {
            return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)matchStack);
        }
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)matchStack);
    }

    @Override
    public boolean isUsable(ItemStack filterStack) {
        ItemFilterComponent component;
        if (filterStack.getItem() instanceof ItemFilterItem && (component = (ItemFilterComponent)filterStack.get((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get())) != null) {
            return component.isPresent() && !component.getStack().isEmpty();
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!this.isUsable(stack)) {
            tooltip.add((Component)TooltipCreator.create((Item)this, (String)"not_configured", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
            tooltip.add((Component)TooltipCreator.create((Item)this, (String)"not_configured", (int)1, (Object[])new Object[]{TooltipCreator.create((String)"usefulbackpacks", (String)"click", (String)"right_click", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})}).withStyle(ChatFormatting.GRAY));
        } else {
            ItemFilterComponent component = (ItemFilterComponent)stack.get((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
            tooltip.add((Component)TooltipCreator.create((Item)this, (String)"configured", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC}));
            tooltip.add((Component)TooltipCreator.create((Item)this, (String)"configured", (int)1, (Object[])new Object[]{Component.translatable((String)component.getStack().getDescriptionId()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)TooltipCreator.create((Item)this, (String)"configured", (int)2, (Object[])new Object[]{Component.literal((String)Boolean.toString(component.isStrict())).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)TooltipCreator.create((Item)this, (String)"configured", (int)3, (Object[])new Object[]{TooltipCreator.create((String)"usefulbackpacks", (String)"click", (String)"shift_right_click", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean canBeDropped(ItemStack stack, Player player) {
        return !(player.containerMenu instanceof ItemFilterMenu);
    }
}

