/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.menu.slot.BackpackSlot;
import info.u_team.useful_backpacks.type.BackpackType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackMenu
extends UContainerMenu {
    private final Container backpackInventory;
    private final BackpackType backpack;
    private final int selectedSlot;

    public static BackpackMenu createClientContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        BackpackType backpack = (BackpackType)buffer.readEnum(BackpackType.class);
        int selectedSlot = buffer.readVarInt();
        return new BackpackMenu(id, playerInventory, (Container)new SimpleContainer(backpack.getInventorySize()), backpack, selectedSlot);
    }

    public BackpackMenu(int id, Inventory playerInventory, Container backpackInventory, BackpackType backpack, int selectedSlot) {
        super((MenuType)UsefulBackpacksMenuTypes.BACKPACK.get(), id);
        this.backpackInventory = backpackInventory;
        this.backpack = backpack;
        this.selectedSlot = selectedSlot;
        this.addBackpackInventory(backpack.getSlotBackpackX(), backpack.getSlotBackpackY());
        this.addPlayerInventory(playerInventory, backpack.getSlotPlayerX(), backpack.getSlotPlayerY());
    }

    public void addBackpackInventory(int x, int y) {
        for (int height = 0; height < this.backpack.getInventoryHeight(); ++height) {
            for (int width = 0; width < this.backpack.getInventoryWidth(); ++width) {
                this.addSlot(new BackpackSlot(this.backpackInventory, width + height * this.backpack.getInventoryWidth(), width * 18 + x, height * 18 + y));
            }
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Container container = this.backpackInventory;
        if (container instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)container;
            inventory.writeItemStack();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.backpack.getInventorySize() ? !this.moveItemStackTo(itemstack1, this.backpack.getInventorySize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.backpack.getInventorySize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.container == player.getInventory() && tmpSlot.getContainerSlot() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.getInventory().getItem(dragType);
            ItemStack itemStack = Inventory.isHotbarSlot((int)this.selectedSlot) ? (ItemStack)player.getInventory().items.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.getInventory().offhand.get(0) : ItemStack.EMPTY);
            if (!currentItem.isEmpty() && stack == currentItem) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public boolean stillValid(Player player) {
        Container container = this.backpackInventory;
        if (container instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)container;
            ItemStack stack = inventory.getStack();
            return !stack.isEmpty() && stack.getItem() instanceof Backpack;
        }
        return true;
    }

    public BackpackType getBackpack() {
        return this.backpack;
    }

    public Container getBackpackInventory() {
        return this.backpackInventory;
    }
}

