/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.init.UsefulBackpacksBlocks;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.inventory.DelegateInventory;
import info.u_team.useful_backpacks.inventory.FilterInventory;
import info.u_team.useful_backpacks.menu.slot.BackpackFilterSlot;
import info.u_team.useful_backpacks.menu.slot.FilterSlot;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class FilterConfiguratorMenu
extends UContainerMenu {
    private final ContainerLevelAccess access;
    private final Container backpackSlotInventory = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            FilterConfiguratorMenu.this.slotsChanged((Container)this);
        }
    };
    private final DelegateInventory filterSlotInventory = new DelegateInventory((Container)new SimpleContainer(9));
    private Container filterInventory;

    public FilterConfiguratorMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.NULL);
        this.filterInventory = new SimpleContainer(9);
    }

    public FilterConfiguratorMenu(int id, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)UsefulBackpacksMenuTypes.FILTER_CONFIGURATOR.get(), id);
        this.access = access;
        this.addSlots((index, xPosition, yPosition) -> new BackpackFilterSlot(this.backpackSlotInventory, index, xPosition, yPosition), 1, 1, 35, 35);
        this.addSlots((index, xPosition, yPosition) -> new FilterSlot(this.backpackSlotInventory, this.filterSlotInventory, index, xPosition, yPosition), 3, 3, 89, 17);
        this.addPlayerInventory(playerInventory, 8, 84);
    }

    public boolean stillValid(Player player) {
        return FilterConfiguratorMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)UsefulBackpacksBlocks.FILTER_CONFIGURATOR.get()));
    }

    public void removed(Player player) {
        super.removed(player);
        this.saveFilterInventory();
        this.access.execute((level, pos) -> this.clearContainer(player, this.backpackSlotInventory));
    }

    public void broadcastChanges() {
        ItemStack newStack;
        boolean stackChanged;
        List lastSlots = this.getLastSlots();
        ItemStack oldStack = (ItemStack)lastSlots.get(0);
        boolean bl = stackChanged = !ItemStack.matches((ItemStack)oldStack, (ItemStack)(newStack = this.backpackSlotInventory.getItem(0)));
        if (stackChanged) {
            if (newStack.getItem() instanceof Backpack) {
                if (this.filterInventory instanceof FilterInventory) {
                    ((FilterInventory)this.filterInventory).writeItemStack();
                }
                this.filterInventory = new FilterInventory(this.backpackSlotInventory.getItem(0));
                this.filterSlotInventory.setInventory(this.filterInventory);
            } else if (newStack.isEmpty() && this.filterInventory instanceof FilterInventory) {
                this.filterInventory = null;
                this.filterSlotInventory.setInventory(null);
            }
        }
        this.saveFilterInventory();
        super.broadcastChanges();
    }

    private void saveFilterInventory() {
        Container container = this.filterInventory;
        if (container instanceof FilterInventory) {
            FilterInventory inventory = (FilterInventory)container;
            inventory.writeItemStack();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 10 ? !this.moveItemStackTo(itemstack1, 10, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 10, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

