/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.menu.slot.ItemFilterSlot;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemFilterMenu
extends UContainerMenu {
    private final ItemStack filterStack;
    private final int selectedSlot;
    private boolean isStrict;
    private final Container filterItemSlotInventory = new SimpleContainer(1);
    private final MessageHolder strictMessage;

    public ItemFilterMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, ItemStack.EMPTY, buffer.readVarInt(), buffer.readBoolean());
    }

    public ItemFilterMenu(int id, Inventory playerInventory, ItemStack filterStack, int selectedSlot, boolean isStrict) {
        super((MenuType)UsefulBackpacksMenuTypes.ITEM_FILTER.get(), id);
        this.filterStack = filterStack;
        this.selectedSlot = selectedSlot;
        this.isStrict = isStrict;
        ItemFilterComponent component = (ItemFilterComponent)filterStack.get((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
        if (component != null && component.isPresent()) {
            this.filterItemSlotInventory.setItem(0, component.getStack());
        }
        this.addSlots((index, xPosition, yPosition) -> new ItemFilterSlot(this.filterItemSlotInventory, index, xPosition, yPosition), 1, 1, 17, 17);
        this.addPlayerInventory(playerInventory, 8, 48);
        this.strictMessage = (MessageHolder)this.addDataHolderToServer((DataHolder)new MessageHolder(buffer -> {
            boolean newIsStrict = buffer.readBoolean();
            if (!filterStack.isEmpty()) {
                filterStack.update((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get(), (Object)ItemFilterComponent.EMPTY, old -> {
                    if (!old.isPresent()) {
                        return ItemFilterComponent.EMPTY;
                    }
                    return ItemFilterComponent.of(newIsStrict, old.getStack());
                });
            }
        }));
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void broadcastChanges() {
        if (!this.filterStack.isEmpty()) {
            ItemStack stackToFilter = this.filterItemSlotInventory.getItem(0);
            this.filterStack.update((DataComponentType)UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get(), (Object)ItemFilterComponent.EMPTY, old -> ItemFilterComponent.of(old.isStrict(), stackToFilter));
        }
        super.broadcastChanges();
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId == 0) {
            this.filterSlotClick(dragType, clickType, player);
            return;
        }
        Slot tmpSlot = slotId >= 0 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.container == player.getInventory() && tmpSlot.getContainerSlot() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.getInventory().getItem(dragType);
            ItemStack itemStack = Inventory.isHotbarSlot((int)this.selectedSlot) ? (ItemStack)player.getInventory().items.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.getInventory().offhand.get(0) : ItemStack.EMPTY);
            if (!currentItem.isEmpty() && stack == currentItem) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    private ItemStack filterSlotClick(int dragType, ClickType clickType, Player player) {
        ItemStack stack;
        if (clickType == ClickType.THROW) {
            this.filterItemSlotInventory.setItem(0, ItemStack.EMPTY);
            stack = ItemStack.EMPTY;
        } else if (clickType == ClickType.PICKUP || clickType == ClickType.CLONE) {
            stack = this.getCarried().copy();
            stack.setCount(1);
            this.filterItemSlotInventory.setItem(0, stack);
        } else if (clickType == ClickType.SWAP) {
            stack = player.getInventory().getItem(dragType).copy();
            stack.setCount(1);
            this.filterItemSlotInventory.setItem(0, stack);
        } else {
            stack = ItemStack.EMPTY;
        }
        return stack;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean isStrict) {
        this.isStrict = isStrict;
    }

    public MessageHolder getStrictMessage() {
        return this.strictMessage;
    }

    public boolean hasFilterItem() {
        return !this.filterItemSlotInventory.getItem(0).isEmpty();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 1) {
                return ItemStack.EMPTY;
            }
            ItemStack stack = itemstack1.copy();
            stack.setCount(1);
            this.filterItemSlotInventory.setItem(0, stack);
            return ItemStack.EMPTY;
        }
        return itemstack;
    }
}

