/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.component.TagFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TagFilterMenu
extends UContainerMenu {
    private final int selectedSlot;
    private String tag;
    private final MessageHolder tagMessage;

    public TagFilterMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, ItemStack.EMPTY, buffer.readVarInt(), buffer.readUtf());
    }

    public TagFilterMenu(int id, Inventory playerInventory, ItemStack filterStack, int selectedSlot, String tag) {
        super((MenuType)UsefulBackpacksMenuTypes.TAG_FILTER.get(), id);
        this.selectedSlot = selectedSlot;
        this.tag = tag;
        this.addPlayerInventory(playerInventory, 8, 108);
        this.tagMessage = (MessageHolder)this.addDataHolderToServer((DataHolder)new MessageHolder(buffer -> {
            String newTag = buffer.readUtf();
            if (!filterStack.isEmpty()) {
                if (newTag.isEmpty()) {
                    filterStack.set((DataComponentType)UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get(), (Object)TagFilterComponent.EMPTY);
                } else {
                    ResourceLocation location = ResourceLocation.tryParse((String)newTag);
                    if (location != null) {
                        filterStack.set((DataComponentType)UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get(), (Object)TagFilterComponent.of(location));
                    }
                }
            }
        }));
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.container == player.getInventory() && tmpSlot.getContainerSlot() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.getInventory().getItem(dragType);
            ItemStack itemStack = Inventory.isHotbarSlot((int)this.selectedSlot) ? (ItemStack)player.getInventory().items.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.getInventory().offhand.get(0) : ItemStack.EMPTY);
            if (!currentItem.isEmpty() && stack == currentItem) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public MessageHolder getTagMessage() {
        return this.tagMessage;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 27 ? !this.moveItemStackTo(itemstack1, 27, 36, false) : !this.moveItemStackTo(itemstack1, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

