/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.mixin;

import info.u_team.useful_backpacks.event.ItemPickupCommonEventHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
abstract class ItemEntityMixin
extends Entity {
    private ItemEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")}, cancellable=true)
    private void usefulbackpacks$drop(Player player, CallbackInfo info) {
        ItemEntity entity = (ItemEntity)this;
        if (entity.hasPickUpDelay() || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack stackToPickup = entity.getItem();
        Item item = stackToPickup.getItem();
        int count = stackToPickup.getCount();
        ItemStack resultStack = ItemPickupCommonEventHandler.insertInBackpacks(serverPlayer, stackToPickup);
        entity.setItem(resultStack.copy());
        if (resultStack.getCount() != stackToPickup.getCount()) {
            player.take((Entity)this, count - resultStack.getCount());
            if (resultStack.isEmpty()) {
                this.discard();
                info.cancel();
            }
            player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), count - resultStack.getCount());
            player.onItemPickup(entity);
        }
    }
}

