/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.recipe;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.recipeserializer.UShapedRecipeSerializer;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksRecipeSerializers;
import info.u_team.useful_backpacks.item.BackpackItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class BackpackCraftingRecipe
extends ShapedRecipe {
    public BackpackCraftingRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack backpackItem = super.assemble(input, registries);
        ArrayList dyeList = Lists.newArrayList();
        boolean backpackPresent = false;
        for (int index = 0; index < input.size(); ++index) {
            DyeColor color;
            ItemStack slotStack = input.getItem(index);
            if (slotStack.isEmpty()) continue;
            Item item2 = slotStack.getItem();
            if (item2 instanceof BackpackItem) {
                if (backpackPresent) {
                    return ItemStack.EMPTY;
                }
                backpackPresent = true;
                backpackItem.applyComponentsAndValidate(slotStack.getComponentsPatch());
                continue;
            }
            if (!slotStack.is(ItemTags.WOOL) || (color = ColorUtil.getColorFromWool((Item)item2)) == null) continue;
            dyeList.add(DyeItem.byColor((DyeColor)color));
        }
        if (!dyeList.isEmpty() && !dyeList.parallelStream().allMatch(item -> item.getDyeColor() == DyeColor.WHITE)) {
            return DyedItemColor.applyDyes((ItemStack)backpackItem, (List)dyeList);
        }
        return backpackItem;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)UsefulBackpacksRecipeSerializers.BACKPACK.get();
    }

    public static class Serializer
    extends UShapedRecipeSerializer<BackpackCraftingRecipe> {
        protected BackpackCraftingRecipe createRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
            return new BackpackCraftingRecipe(group, category, pattern, result, showNotification);
        }
    }
}

