/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.screen;

import info.u_team.u_team_core.gui.elements.ScrollableList;
import info.u_team.u_team_core.util.RegistryUtil;
import info.u_team.u_team_core.util.ResourceLocationUtil;
import info.u_team.useful_backpacks.menu.TagFilterMenu;
import info.u_team.useful_backpacks.screen.TagFilterTagListEntry;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagFilterTagList
extends ScrollableList<TagFilterTagListEntry> {
    private final TagFilterMenu menu;

    public TagFilterTagList(TagFilterMenu menu, int x, int y, int width, int height, String tag) {
        super(x, y, width, height, 10, 15);
        this.menu = menu;
        this.setRenderHeader(false, 0);
        this.setRenderTransparentBorder(true);
        this.updateEntries(unused -> true);
        if (!tag.isEmpty()) {
            this.children().stream().filter(entry -> entry.getTag().toString().equals(tag)).findAny().ifPresent(entry -> {
                super.setSelected((AbstractSelectionList.Entry)entry);
                this.centerScrollOn((AbstractSelectionList.Entry)entry);
            });
        }
    }

    public void setSelected(TagFilterTagListEntry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        String tag = entry.getTag().toString();
        this.menu.getTagMessage().triggerMessage(() -> new FriendlyByteBuf(Unpooled.buffer((int)100)).writeUtf(tag));
        this.menu.setTag(tag);
    }

    public void updateSearch(String search) {
        if (search.isEmpty()) {
            this.updateEntries(tag -> true);
        } else {
            this.updateEntries(tag -> tag.getNamespace().startsWith(search) || tag.getPath().startsWith(search));
        }
    }

    private void updateEntries(Predicate<ResourceLocation> predicate) {
        List<ResourceLocation> list = RegistryUtil.getBuiltInRegistry((ResourceKey)Registries.ITEM).asLookup().listTagIds().filter(tagKey -> predicate.test(tagKey.location())).map(TagKey::location).collect(Collectors.toList());
        Collections.sort(list, ResourceLocationUtil.nameSpacedComparator());
        TagFilterTagListEntry selected = (TagFilterTagListEntry)this.getSelected();
        this.clearEntries();
        this.setScrollAmount(0.0);
        list.forEach(tag -> {
            TagFilterTagListEntry entry = new TagFilterTagListEntry((ResourceLocation)tag);
            this.addEntry((AbstractSelectionList.Entry)entry);
            if (selected != null && selected.getTag().equals(tag)) {
                super.setSelected((AbstractSelectionList.Entry)entry);
            }
        });
        if (this.getSelected() != null) {
            this.centerScrollOn((AbstractSelectionList.Entry)((TagFilterTagListEntry)this.getSelected()));
        }
    }
}

