/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public class BiFilterSerializer {
    private final NamedTypeRegistry<BiFilter> REGISTRY = new NamedTypeRegistry().addConstructorPattern(CompoundTag.class);

    public <V extends BiFilter & CompoundSerializer> BiFilterSerializer register(String id, Class<V> clazz) {
        this.REGISTRY.register(id, clazz);
        return this;
    }

    public CompoundTag write(BiFilter filter) throws RegistryException {
        if (filter instanceof BiFilter.BiFilterAnd) {
            BiFilter.BiFilterAnd biFilter = (BiFilter.BiFilterAnd)filter;
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (BiFilter child : biFilter.filters()) {
                list.add((Object)this.write(child));
            }
            tag.put("c", (Tag)list);
            tag.putString("t", "&");
            return tag;
        }
        if (filter instanceof BiFilter.BiFilterOr) {
            BiFilter.BiFilterOr biFilter = (BiFilter.BiFilterOr)filter;
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (BiFilter child : biFilter.filters()) {
                list.add((Object)this.write(child));
            }
            tag.put("c", (Tag)list);
            tag.putString("t", "+");
            return tag;
        }
        if (filter instanceof BiFilter.BiFilterNot) {
            BiFilter.BiFilterNot biFilter = (BiFilter.BiFilterNot)filter;
            CompoundTag tag = new CompoundTag();
            tag.put("c", (Tag)this.write(biFilter.filter()));
            tag.putString("t", "!");
            return tag;
        }
        if (filter instanceof CompoundSerializer) {
            CompoundSerializer serializer = (CompoundSerializer)((Object)filter);
            CompoundTag tag = serializer.write();
            tag.putString("t", this.REGISTRY.getId(filter));
            return tag;
        }
        throw new RegistryException("Type not registered " + String.valueOf(filter.getClass()));
    }

    public BiFilter read(CompoundTag tag) throws RegistryException {
        String type;
        switch (type = tag.getString("t")) {
            case "&": {
                ListTag list = tag.getList(type, 10);
                BiFilter[] filters = new BiFilter[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    filters[i] = this.read(list.getCompound(i));
                }
                return new BiFilter.BiFilterAnd(filters);
            }
            case "+": {
                ListTag list = tag.getList(type, 10);
                BiFilter[] filters = new BiFilter[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    filters[i] = this.read(list.getCompound(i));
                }
                return new BiFilter.BiFilterOr(filters);
            }
            case "!": {
                return new BiFilter.BiFilterNot(this.read(tag.getCompound("c")));
            }
        }
        return this.REGISTRY.create(type, tag);
    }
}

