/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.entity.EngineVehicle;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;

public class VectorIndicator
implements Indicator {
    public static final VectorIndicator INSTANCE = new VectorIndicator();
    private float pitchRate = 0.0f;
    private float yawRate = 0.0f;
    private float rollRate = 0.0f;
    private Vec3 lastSpeed = new Vec3(0.0, 0.0, 0.0);
    private Vec3 iSpeed = new Vec3(0.0, 0.0, 0.0);
    private Vec3 iSpeedRt = new Vec3(0.0, 0.0, 0.0);
    private double hAngle = 0.0;

    @Override
    public void update(Minecraft client, EngineVehicle aircraft) {
        float pitch = aircraft.getXRot();
        this.pitchRate = (pitch - aircraft.xRotO) * 20.0f;
        float yaw = aircraft.getYRot();
        this.yawRate = (yaw - aircraft.yRotO) * 20.0f;
        float roll = aircraft.getRoll();
        this.rollRate = (float)Math.toRadians((roll - aircraft.prevRoll) * 20.0f);
        Vec3 speed = aircraft.getSpeedVector().scale(20.0);
        if (!speed.equals((Object)this.lastSpeed)) {
            this.iSpeed = speed.add(this.lastSpeed.reverse());
            this.iSpeedRt = this.iSpeed.scale(-0.03333333507180214);
            this.lastSpeed = speed;
        }
        if (this.iSpeed.add(this.iSpeedRt).dot(this.iSpeed) > 0.0) {
            this.iSpeed = this.iSpeed.add(this.iSpeedRt);
        } else {
            this.iSpeed = new Vec3(0.0, 0.0, 0.0);
            this.iSpeedRt = new Vec3(0.0, 0.0, 0.0);
        }
        Vec3 mSpeed = this.lastSpeed.add(this.iSpeed.reverse());
        Vec3 vNormal = Vec3.directionFromRotation((float)0.0f, (float)(yaw + 90.0f));
        this.hAngle = Math.toDegrees(Math.asin(mSpeed.normalize().dot(vNormal)));
    }

    @Override
    public void drawDashboard(GuiGraphics context, Minecraft client, int baseX, int baseY, EngineVehicle aircraft, int color) {
    }

    @Override
    public void drawHUD(GuiGraphics context, Minecraft client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        int hsx;
        if (this.edgeCheck(edge, 5, baseX, baseY - width / 10)) {
            StringDrawer.drawString5(context, client, "\u00afW\u00af", baseX + 1, baseY - width * 30 / 100 + 3, color, false);
        }
        if (this.edgeCheck(edge, 5, baseX - width * 10 / 100, baseY)) {
            OverlayRenderer.renderLine(context, baseX - width * 15 / 100 - 4, baseY, baseX - width * 5 / 100 - 4, baseY, color);
        }
        if (this.edgeCheck(edge, 8, baseX - width * 37 / 100, baseY)) {
            OverlayRenderer.renderLine(context, baseX - width * 45 / 100 - 2, baseY, baseX - width * 30 / 100 - 2, baseY, color);
        }
        if (this.edgeCheck(edge, 5, baseX + width * 10 / 100, baseY)) {
            OverlayRenderer.renderLine(context, baseX + width * 5 / 100 + 2, baseY, baseX + width * 15 / 100 + 2, baseY, color);
        }
        if (this.edgeCheck(edge, 8, baseX + width * 37 / 100, baseY)) {
            OverlayRenderer.renderLine(context, baseX + width * 30 / 100, baseY, baseX + width * 45 / 100, baseY, color);
        }
        if (this.edgeCheck(edge, 5, baseX - width * 6 / 100, baseY)) {
            StringDrawer.drawString6(context, client, "\u25b7", baseX - width * 5 / 100, baseY, color, false);
        }
        if (this.edgeCheck(edge, 5, baseX + width * 6 / 100, baseY)) {
            StringDrawer.drawString4(context, client, "\u25c1", baseX + width * 5 / 100 + 1, baseY, color, false);
        }
        if (this.edgeCheck(edge, 2, baseX + 1, baseY + width * 45 / 100 - 1)) {
            StringDrawer.drawString2(context, client, "'", baseX + 1, baseY + width * 45 / 100 - 1, color, false);
        }
        IntStream.range(1, 13).forEach(i -> {
            int y = baseY + width * 45 / 100 - (i >= 10 ? 1 : 0);
            if (this.edgeCheck(edge, 2, baseX + 1 + i * width / 40, y)) {
                StringDrawer.drawString2(context, client, "'", baseX + 1 + i * width / 40, y, color, false);
            }
            if (this.edgeCheck(edge, 2, baseX + 1 - i * width / 40, y)) {
                StringDrawer.drawString2(context, client, "'", baseX + 1 - i * width / 40, y, color, false);
            }
        });
        if (this.edgeCheck(edge, 5, baseX + 1 + (int)(this.rollRate * (float)width / 4.0f), baseY + width * 45 / 100 - 4)) {
            StringDrawer.drawString8(context, client, "\u25bd", baseX + 1 + (int)(this.rollRate * (float)width / 4.0f), baseY + width * 45 / 100, color, false);
        }
        if (this.edgeCheck(edge, 5, hsx = baseX - (int)(this.hAngle * (double)width / 900.0) + 1, baseY + width * 45 / 100 - 1)) {
            StringDrawer.drawString8(context, client, "\u2b58", hsx, baseY + width * 45 / 100 + 7, color, false);
        }
        int x0 = baseX;
        int y0 = baseY;
        if (this.edgeCheck(edge, 5, x0 = (int)((float)x0 - this.yawRate * (float)width / 200.0f), y0 = (int)((float)y0 - this.pitchRate * (float)width / 200.0f))) {
            context.renderOutline(x0 - 3, y0 - 2, 5, 5, color);
            OverlayRenderer.renderLine(context, x0 - 1, y0 - 5, x0 - 1, y0 - 2, color);
            OverlayRenderer.renderLine(context, x0 - 6, y0, x0 - 3, y0, color);
            OverlayRenderer.renderLine(context, x0 + 1, y0, x0 + 4, y0, color);
        }
    }

    @Override
    public void drawDials(GuiGraphics context, Minecraft client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorLt0);
        int xr = baseX - (int)((double)this.yawRate * 0.15 * (double)scale);
        int yr = baseY - (int)((double)this.pitchRate * 0.15 * (double)scale);
        int[] edge0 = new int[]{baseY - 27 * scale, baseY + 27 * scale, baseX - 27 * scale, baseX + 27 * scale};
        if (this.edgeCheck(edge0, 5, xr, yr)) {
            context.renderOutline(xr - 2, yr - 2, 5, 5, Colors.colorBG);
            OverlayRenderer.renderLine(context, xr, yr - 5, xr, yr - 2, Colors.colorBG);
            OverlayRenderer.renderLine(context, xr - 5, yr, xr - 2, yr, Colors.colorBG);
            OverlayRenderer.renderLine(context, xr + 2, yr, xr + 5, yr, Colors.colorBG);
        }
        StringDrawer.drawString5(context, client, "\u23fa", baseX - (int)(this.hAngle * (double)scale / 6.0) + 2, baseY + 15 * scale + 1, Colors.colorHD1, true);
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY - 19 * scale + 1, Colors.colorBG);
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX - 19 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        context.fill(baseX + 19 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        context.fill(baseX - 27 * scale, baseY + 19 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        OverlayRenderer.drawDialOutline(context, baseX, baseY, scale);
        context.fill(baseX - 18 * scale, baseY - 18 * scale, baseX + 18 * scale + 1, baseY - 17 * scale, Colors.colorSD);
        context.fill(baseX - 18 * scale, baseY - 18 * scale, baseX - 17 * scale, baseY + 18 * scale + 1, Colors.colorSD);
        context.fill(baseX - 19 * scale, baseY - 19 * scale, baseX + 19 * scale + 1, baseY - 18 * scale, Colors.colorFG);
        context.fill(baseX - 19 * scale, baseY - 19 * scale, baseX - 18 * scale, baseY + 19 * scale + 1, Colors.colorFG);
        context.fill(baseX - 19 * scale, baseY + 18 * scale + 1, baseX + 19 * scale + 1, baseY + 19 * scale + 1, Colors.colorFG);
        context.fill(baseX + 18 * scale + 1, baseY - 19 * scale, baseX + 19 * scale + 1, baseY + 19 * scale + 1, Colors.colorFG);
        context.fill(baseX - 25 * scale, baseY, baseX - 19 * scale + 1, baseY + 1, Colors.colorHD1);
        context.fill(baseX + 19 * scale, baseY, baseX + 25 * scale + 1, baseY + 1, Colors.colorHD1);
        context.fill(baseX, baseY - 25 * scale, baseX + 1, baseY - 19 * scale + 1, Colors.colorHD1);
        OverlayRenderer.renderLine(context, baseX - 20 * scale, baseY + 14 * scale, baseX + 20 * scale, baseY + 14 * scale, Colors.colorG);
        OverlayRenderer.renderLine(context, baseX - 20 * scale, baseY + 18 * scale, baseX + 20 * scale, baseY + 18 * scale, Colors.colorG);
        OverlayRenderer.renderLine(context, baseX - 2 * scale, baseY + 14 * scale, baseX - 2 * scale, baseY + 18 * scale, Colors.colorHD1);
        OverlayRenderer.renderLine(context, baseX + 2 * scale, baseY + 14 * scale, baseX + 2 * scale, baseY + 18 * scale, Colors.colorHD1);
        OverlayRenderer.renderLine(context, baseX - 20 * scale, baseY + 14 * scale, baseX - 20 * scale, baseY + 18 * scale, Colors.colorFG);
        OverlayRenderer.renderLine(context, baseX + 20 * scale, baseY + 14 * scale, baseX + 20 * scale, baseY + 18 * scale, Colors.colorFG);
        OverlayRenderer.renderLine(context, baseX - 26 * scale, baseY - 18 * scale, baseX - 2 * scale, baseY - 18 * scale, Colors.colorHD2, false, true);
        OverlayRenderer.renderLine(context, baseX + 2 * scale, baseY - 18 * scale, baseX + 26 * scale, baseY - 18 * scale, Colors.colorHD2, false, true);
        StringDrawer.drawString2(context, client, "\u00afW\u00af", baseX + 2, baseY - 18 * scale - 1, Colors.colorHD2, true);
        if (scale > 1) {
            StringDrawer.drawString9(context, client, "TC", baseX + 20 * scale + 1, baseY + 25 * scale + 1, Colors.colorFG, false);
        } else {
            int x = baseX + 13;
            int y = baseY + 26;
            context.fill(x, y - 5, x + 3, y - 4, Colors.colorFG);
            context.fill(x + 1, y - 4, x + 2, y, Colors.colorFG);
            x = baseX + 16;
            y = baseY + 26;
            context.fill(x + 1, y - 5, x + 3, y - 4, Colors.colorFG);
            context.fill(x, y - 4, x + 1, y - 1, Colors.colorFG);
            context.fill(x + 1, y - 1, x + 3, y, Colors.colorFG);
        }
        for (int i = -16; i <= 16; i += 2) {
            context.fill(baseX + i * scale, baseY + 25 * scale + 1, baseX + i * scale + 1, baseY + 26 * scale + 1, Math.abs(i) >= 10 ? Colors.colorFG2 : Colors.colorBG);
        }
        StringDrawer.drawString2(context, client, "\u23f7", baseX + (int)(this.rollRate * (float)scale * 10.0f) + 2, baseY + 25 * scale - 4, Colors.colorHD1, true);
    }
}

