/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.client.ColorUtils;
import immersive_aircraft.entity.VehicleEntity;
import java.awt.Color;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class DyeableVehicleEntity
extends VehicleEntity {
    protected static final EntityDataAccessor<Integer> DYE_COLOR = SynchedEntityData.defineId(DyeableVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public DyeableVehicleEntity(EntityType<? extends VehicleEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(DYE_COLOR, (Object)-1);
    }

    @Override
    public void addItemTag(ItemStack stack) {
        super.addItemTag(stack);
        if (this.getDyeColor() >= 0) {
            stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(this.getDyeColor(), true));
        }
    }

    @Override
    public void readItemTag(ItemStack stack) {
        super.readItemTag(stack);
        DyedItemColor dyedColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (dyedColor != null) {
            this.setDyeColor(dyedColor.rgb());
        }
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Color")) {
            this.setDyeColor(tag.getInt("Color"));
        }
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Color", this.getDyeColor());
    }

    public int getDyeColor() {
        return (Integer)this.entityData.get(DYE_COLOR);
    }

    public void setDyeColor(int v) {
        this.entityData.set(DYE_COLOR, (Object)v);
    }

    public int getBodyColor() {
        int[] rgb = ColorUtils.hexToRGB(this.getDyeColor() < 0 ? this.getDefaultDyeColor() : this.getDyeColor());
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        hsb[2] = Mth.clamp((float)hsb[2], (float)0.18f, (float)0.95f);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return resultColor.getRGB();
    }

    public int getHighlightColor() {
        int[] rgb = ColorUtils.hexToRGB(this.getBodyColor());
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        hsb[1] = Mth.clamp((float)(hsb[1] * 0.88311f), (float)0.0f, (float)1.0f);
        hsb[2] = Mth.clamp((float)(hsb[2] * 1.11494f), (float)0.0f, (float)1.0f);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return resultColor.getRGB();
    }

    public int getDefaultDyeColor() {
        return 0xFFFFFF;
    }

    @Override
    public Component getDisplayName() {
        return super.getDisplayName();
    }
}

