/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.beb;

import com.cerbon.beb.util.MiscUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class BeautifulEnchantedBooks {
    private static final Map<ResourceLocation, ModelResourceLocation> REGISTERED_MODEL_IDS_ML = new HashMap<ResourceLocation, ModelResourceLocation>();
    private static final Map<ResourceLocation, ResourceLocation> REGISTERED_MODEL_IDS_RL = new HashMap<ResourceLocation, ResourceLocation>();
    public static final String MODEL_PREFIX = "item/enchanted_book";

    public static void registerModel(ResourceLocation enchantId, ModelResourceLocation model) {
        if (MiscUtils.getPlatformName().equals("Fabric")) {
            REGISTERED_MODEL_IDS_RL.put(enchantId, model.id());
        } else {
            REGISTERED_MODEL_IDS_ML.put(enchantId, model);
        }
    }

    public static ModelResourceLocation ofVariantMl(ResourceLocation variantId) {
        return REGISTERED_MODEL_IDS_ML.get(variantId);
    }

    public static ResourceLocation ofVariantRl(ResourceLocation variantId) {
        return REGISTERED_MODEL_IDS_RL.get(variantId);
    }

    public static Set<ResourceLocation> findCITs(ResourceManager manager) {
        HashSet<ResourceLocation> variantIds = new HashSet<ResourceLocation>();
        String folder = "models/item/enchanted_book";
        for (ResourceLocation resourceLocation : manager.listResources(folder, rl -> rl.getPath().endsWith(".json")).keySet()) {
            String path = resourceLocation.getPath();
            path = path.substring(folder.length() + 1, path.length() - ".json".length());
            variantIds.add(ResourceLocation.tryBuild((String)resourceLocation.getNamespace(), (String)path));
        }
        return variantIds;
    }
}

