/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.undeadrevamp.entity;

import javax.annotation.Nullable;
import net.mcreator.undeadrevamp.procedures.CloggerEntityDiesProcedure;
import net.mcreator.undeadrevamp.procedures.CloggerEntityIsHurtProcedure;
import net.mcreator.undeadrevamp.procedures.CloggerOnEntityTickUpdateProcedure;
import net.mcreator.undeadrevamp.procedures.CloggerOnInitialEntitySpawnProcedure;
import net.mcreator.undeadrevamp.procedures.ClogrushProcedure;
import net.mcreator.undeadrevamp.procedures.NoatkbidProcedure;
import net.mcreator.undeadrevamp.procedures.ThebeartamerDeathTimeIsReachedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CloggerEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_smashmode = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_rushmode = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_honeyman_a = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_eating = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_honeyman_b = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_honeyman_c = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_activatehitbox = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_explo = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_tt = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_passorsmash = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_pastat = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_inrange = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_phase = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_wait = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_noatk = SynchedEntityData.defineId(CloggerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public CloggerEntity(EntityType<CloggerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 12;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"theclogger");
        builder.define(DATA_smashmode, (Object)0);
        builder.define(DATA_rushmode, (Object)1);
        builder.define(DATA_honeyman_a, (Object)0);
        builder.define(DATA_eating, (Object)0);
        builder.define(DATA_honeyman_b, (Object)0);
        builder.define(DATA_honeyman_c, (Object)0);
        builder.define(DATA_activatehitbox, (Object)0);
        builder.define(DATA_explo, (Object)0);
        builder.define(DATA_tt, (Object)0);
        builder.define(DATA_passorsmash, (Object)0);
        builder.define(DATA_pastat, (Object)1);
        builder.define(DATA_inrange, (Object)3);
        builder.define(DATA_phase, (Object)1);
        builder.define(DATA_wait, (Object)0);
        builder.define(DATA_noatk, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 42.25 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && ClogrushProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && ClogrushProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Illusioner.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, SpellcasterIllager.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, false){

            public boolean canUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canUse() && NoatkbidProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CloggerEntity.this.getX();
                double y = CloggerEntity.this.getY();
                double z = CloggerEntity.this.getZ();
                CloggerEntity entity = CloggerEntity.this;
                Level world = CloggerEntity.this.level();
                return super.canContinueToUse() && NoatkbidProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.8f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"undead_revamp2:cloggerambt"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"undead_revamp2:impact")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"undead_revamp2:cloggerbleed"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"undead_revamp2:cloggerdeath"));
    }

    public boolean hurt(DamageSource source, float amount) {
        CloggerEntityIsHurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        Entity immediatesourceentity = source.getDirectEntity();
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        CloggerEntityDiesProcedure.execute((Entity)this, source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CloggerOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putInt("Datasmashmode", ((Integer)this.entityData.get(DATA_smashmode)).intValue());
        compound.putInt("Datarushmode", ((Integer)this.entityData.get(DATA_rushmode)).intValue());
        compound.putInt("Datahoneyman_a", ((Integer)this.entityData.get(DATA_honeyman_a)).intValue());
        compound.putInt("Dataeating", ((Integer)this.entityData.get(DATA_eating)).intValue());
        compound.putInt("Datahoneyman_b", ((Integer)this.entityData.get(DATA_honeyman_b)).intValue());
        compound.putInt("Datahoneyman_c", ((Integer)this.entityData.get(DATA_honeyman_c)).intValue());
        compound.putInt("Dataactivatehitbox", ((Integer)this.entityData.get(DATA_activatehitbox)).intValue());
        compound.putInt("Dataexplo", ((Integer)this.entityData.get(DATA_explo)).intValue());
        compound.putInt("Datatt", ((Integer)this.entityData.get(DATA_tt)).intValue());
        compound.putInt("Datapassorsmash", ((Integer)this.entityData.get(DATA_passorsmash)).intValue());
        compound.putInt("Datapastat", ((Integer)this.entityData.get(DATA_pastat)).intValue());
        compound.putInt("Datainrange", ((Integer)this.entityData.get(DATA_inrange)).intValue());
        compound.putInt("Dataphase", ((Integer)this.entityData.get(DATA_phase)).intValue());
        compound.putInt("Datawait", ((Integer)this.entityData.get(DATA_wait)).intValue());
        compound.putBoolean("Datanoatk", ((Boolean)this.entityData.get(DATA_noatk)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datasmashmode")) {
            this.entityData.set(DATA_smashmode, (Object)compound.getInt("Datasmashmode"));
        }
        if (compound.contains("Datarushmode")) {
            this.entityData.set(DATA_rushmode, (Object)compound.getInt("Datarushmode"));
        }
        if (compound.contains("Datahoneyman_a")) {
            this.entityData.set(DATA_honeyman_a, (Object)compound.getInt("Datahoneyman_a"));
        }
        if (compound.contains("Dataeating")) {
            this.entityData.set(DATA_eating, (Object)compound.getInt("Dataeating"));
        }
        if (compound.contains("Datahoneyman_b")) {
            this.entityData.set(DATA_honeyman_b, (Object)compound.getInt("Datahoneyman_b"));
        }
        if (compound.contains("Datahoneyman_c")) {
            this.entityData.set(DATA_honeyman_c, (Object)compound.getInt("Datahoneyman_c"));
        }
        if (compound.contains("Dataactivatehitbox")) {
            this.entityData.set(DATA_activatehitbox, (Object)compound.getInt("Dataactivatehitbox"));
        }
        if (compound.contains("Dataexplo")) {
            this.entityData.set(DATA_explo, (Object)compound.getInt("Dataexplo"));
        }
        if (compound.contains("Datatt")) {
            this.entityData.set(DATA_tt, (Object)compound.getInt("Datatt"));
        }
        if (compound.contains("Datapassorsmash")) {
            this.entityData.set(DATA_passorsmash, (Object)compound.getInt("Datapassorsmash"));
        }
        if (compound.contains("Datapastat")) {
            this.entityData.set(DATA_pastat, (Object)compound.getInt("Datapastat"));
        }
        if (compound.contains("Datainrange")) {
            this.entityData.set(DATA_inrange, (Object)compound.getInt("Datainrange"));
        }
        if (compound.contains("Dataphase")) {
            this.entityData.set(DATA_phase, (Object)compound.getInt("Dataphase"));
        }
        if (compound.contains("Datawait")) {
            this.entityData.set(DATA_wait, (Object)compound.getInt("Datawait"));
        }
        if (compound.contains("Datanoatk")) {
            this.entityData.set(DATA_noatk, (Object)compound.getBoolean("Datanoatk"));
        }
    }

    public void baseTick() {
        super.baseTick();
        CloggerOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.2f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 210.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 5.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isAggressive())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("dies"));
            }
            if (this.isAggressive() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("run"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("eat"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 90) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
            ThebeartamerDeathTimeIsReachedProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

