/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.client.ParagliderClientItemExtension;
import tictim.paraglider.client.ParagliderGuiLayers;
import tictim.paraglider.client.ParaglidingItemProperty;
import tictim.paraglider.client.WindParticleProvider;
import tictim.paraglider.client.settings.ParagliderClientSettings;
import tictim.paraglider.client.settings.ParagliderClientSettingsIO;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.stamina.StaminaLoader;

@Mod(value="paraglider", dist={Dist.CLIENT})
public class ParagliderClientMod
implements ParagliderMod.IClient {
    private static ParagliderClientMod instance;
    private final boolean removeStaminaWheel;
    @Nullable
    private final String staminaWheelRemoverId;
    @Nullable
    private ParagliderClientSettings clientSettings;
    @Nullable
    private PlayerStateMap syncedStateMap;
    @Nullable
    private KeyMapping paragliderSettingsKey;

    @NotNull
    public static ParagliderClientMod instance() {
        if (instance == null) {
            throw new IllegalStateException("No client");
        }
        return instance;
    }

    public ParagliderClientMod(ModContainer modContainer, IEventBus eventBus) {
        if (instance != null) {
            throw new IllegalStateException("Paraglider mod instantiated twice");
        }
        instance = this;
        ParagliderMod.instance().client = this;
        Pair<Boolean, String> pair = StaminaLoader.loadStaminaWheelRemoverId();
        this.removeStaminaWheel = (Boolean)pair.getFirst();
        this.staminaWheelRemoverId = (String)pair.getSecond();
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        eventBus.addListener(event -> {
            this.paragliderSettingsKey = new KeyMapping("key.paraglider.paragliderSettings", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 80, "key.categories.misc");
            event.register(this.paragliderSettingsKey);
        });
        eventBus.addListener(event -> {
            event.registerAboveAll(ParagliderAPI.id("stamina_wheel"), ParagliderGuiLayers::renderStaminaWheel);
            event.registerAboveAll(ParagliderAPI.id("movement_debug"), ParagliderGuiLayers::renderMovementDebug);
        });
        eventBus.addListener(event -> event.register(Registries.PARTICLE_TYPE, h -> h.register(WindParticleProvider.PARTICLE_TYPE_ID, (Object)WindParticleProvider.PARTICLE_TYPE)));
        eventBus.addListener(event -> event.registerSpriteSet((ParticleType)WindParticleProvider.PARTICLE_TYPE, WindParticleProvider::new));
        eventBus.addListener(event -> {
            Contents c = Contents.get();
            event.registerItem((IClientItemExtensions)ParagliderClientItemExtension.INSTANCE, new Item[]{c.paraglider(), c.dekuLeaf()});
        });
        eventBus.addListener(event -> {
            Contents c = Contents.get();
            event.register((stack, tintIndex) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)-5875371), new ItemLike[]{c.paraglider()});
            event.register((stack, tintIndex) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)-12602049), new ItemLike[]{c.dekuLeaf()});
        });
        eventBus.addListener(event -> event.enqueueWork(() -> {
            ResourceLocation paraglidingId = ParagliderAPI.id("paragliding");
            ParaglidingItemProperty paragliding = new ParaglidingItemProperty();
            ItemProperties.register((Item)Contents.get().paraglider(), (ResourceLocation)paraglidingId, (ItemPropertyFunction)paragliding);
            ItemProperties.register((Item)Contents.get().dekuLeaf(), (ResourceLocation)paraglidingId, (ItemPropertyFunction)paragliding);
        }));
        NeoForge.EVENT_BUS.addListener(event -> {
            this.syncedStateMap = null;
        });
        ParagliderClientSettingsIO.load(null);
    }

    @NotNull
    public ParagliderClientSettings getSettings() {
        return Objects.requireNonNullElse(this.clientSettings, ParagliderClientSettings.DEFAULT);
    }

    public void setSettings(@Nullable ParagliderClientSettings settings) {
        this.clientSettings = settings;
    }

    @NotNull
    public KeyMapping getParagliderSettingsKey() {
        if (this.paragliderSettingsKey == null) {
            throw new IllegalStateException("paragliderSettingsKey is not available yet");
        }
        return this.paragliderSettingsKey;
    }

    @Override
    @Nullable
    public PlayerStateMap getSyncedStateMap() {
        return this.syncedStateMap;
    }

    public void setSyncedStateMap(@Nullable PlayerStateMap stateMap) {
        this.syncedStateMap = stateMap;
    }

    public boolean removeStaminaWheel() {
        return this.removeStaminaWheel;
    }

    @Nullable
    public String staminaWheelRemoverId() {
        return this.staminaWheelRemoverId;
    }
}

