/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.config.PlayerStateMapConfig;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.impl.movement.PlayerStateMap;

public final class ParagliderCommands {
    private ParagliderCommands() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"paraglider").then(ParagliderCommands.queryVessel())).then(ParagliderCommands.setVessel(SetType.set))).then(ParagliderCommands.setVessel(SetType.give))).then(ParagliderCommands.setVessel(SetType.take))).then(ParagliderCommands.bargain())).then(ParagliderCommands.reloadPlayerStates());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> queryVessel() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(s -> s.hasPermission(1))).then(Commands.literal((String)ResourceType.HEART.name).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> ResourceType.HEART.tell((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))))).then(Commands.literal((String)ResourceType.STAMINA.name).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> ResourceType.STAMINA.tell((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))))).then(Commands.literal((String)ResourceType.ESSENCE.name).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> ResourceType.ESSENCE.tell((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setVessel(@NotNull SetType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)type.name()).requires(s -> s.hasPermission(2))).then(Commands.literal((String)ResourceType.HEART.name).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.HEART.run((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))))).then(Commands.literal((String)ResourceType.STAMINA.name).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.STAMINA.run((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))))).then(Commands.literal((String)ResourceType.ESSENCE.name).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.ESSENCE.run((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> bargain() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bargain").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"start").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"bargainType", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"bargainType"), null, null, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"bargainType"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"), null, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"advancement", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"bargainType"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"advancement"), null))).then(Commands.argument((String)"lookAt", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"bargainType"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"advancement"), Vec3Argument.getVec3((CommandContext)ctx, (String)"lookAt")))))))))).then(Commands.literal((String)"end").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> ParagliderCommands.endBargain((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reloadPlayerStates() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reloadPlayerStates").requires(s -> s.hasPermission(3))).executes(context -> ParagliderCommands.reloadPlayerStates((CommandSourceStack)context.getSource()));
    }

    private static int startBargain(@NotNull CommandSourceStack source, @NotNull ServerPlayer player, @NotNull ResourceLocation bargainType, @Nullable BlockPos pos, @Nullable ResourceLocation advancement, @Nullable Vec3 lookAt) {
        if (BargainTypeRegistry.getFromID(player.serverLevel(), bargainType) == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.paraglider.bargain.start.invalid_bargain_type", (Object[])new Object[]{bargainType}));
            return -1;
        }
        if (BargainHandler.initiate((Player)player, bargainType, pos, advancement, lookAt)) {
            source.sendSuccess(() -> Component.translatable((String)"commands.paraglider.bargain.start.success", (Object[])new Object[]{player.getDisplayName(), bargainType}), true);
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"commands.paraglider.bargain.start.no_bargain", (Object[])new Object[]{player.getDisplayName(), String.valueOf(bargainType), String.valueOf(pos)}));
        return 0;
    }

    private static int endBargain(@NotNull CommandSourceStack source, @NotNull ServerPlayer player) {
        BargainContext bargain = BargainHandler.getBargain(player);
        if (bargain != null) {
            if (bargain.isFinished()) {
                source.sendFailure((Component)Component.translatable((String)"command.paraglider.bargain.end.already_finished", (Object[])new Object[]{player.getDisplayName()}));
                return 0;
            }
            source.sendSuccess(() -> Component.translatable((String)"command.paraglider.bargain.end.success", (Object[])new Object[]{player.getDisplayName()}), true);
            bargain.markFinished();
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"command.paraglider.bargain.end.no_bargain", (Object[])new Object[]{player.getDisplayName()}));
        return -1;
    }

    private static int reloadPlayerStates(final @NotNull CommandSourceStack source) {
        ParagliderMod.instance().getPlayerStateMapConfig().reload(new PlayerStateMapConfig.Callback(){

            @Override
            public void onSuccess(@NotNull PlayerStateMap stateMap, boolean updated) {
                source.sendSuccess(() -> Component.translatable((String)"commands.paraglider.reload_player_states.success"), true);
            }

            @Override
            public void onFail(@NotNull PlayerStateMap stateMap, @NotNull RuntimeException exception, boolean update) {
                source.sendFailure((Component)Component.translatable((String)"commands.paraglider.reload_player_states.fail"));
            }
        });
        return 1;
    }

    private static enum SetType {
        set,
        give,
        take;

    }

    private static enum ResourceType {
        HEART("heart_container"),
        STAMINA("stamina_vessel"),
        ESSENCE("essence");

        private final String name;
        private final String getResult;
        private final String setSuccess;
        private final String setNoChange;
        private final String giveSuccess;
        private final String takeSuccess;
        private final String setTooHigh;
        private final String setTooLow;
        private final String setFail;
        private final String giveFail;
        private final String takeFail;

        private ResourceType(String name) {
            this.name = name;
            this.getResult = "commands.paraglider.get." + name + ".result";
            this.setSuccess = "commands.paraglider.set." + name + ".success";
            this.setNoChange = "commands.paraglider.set." + name + ".no_change";
            this.giveSuccess = "commands.paraglider.give." + name + ".success";
            this.takeSuccess = "commands.paraglider.take." + name + ".success";
            this.setTooHigh = "commands.paraglider.set." + name + ".too_high";
            this.setTooLow = "commands.paraglider.set." + name + ".too_low";
            this.setFail = "commands.paraglider.set." + name + ".fail";
            this.giveFail = "commands.paraglider.give." + name + ".fail";
            this.takeFail = "commands.paraglider.take." + name + ".fail";
        }

        private int tell(@NotNull CommandSourceStack source, @NotNull Player player) {
            VesselContainer vessels = VesselContainer.get(player);
            int value = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> vessels.heartContainer();
                case 1 -> vessels.staminaVessel();
                case 2 -> vessels.essence();
            };
            source.sendSuccess(() -> Component.translatable((String)this.getResult, (Object[])new Object[]{player.getDisplayName(), value}), false);
            return value;
        }

        private int run(@NotNull CommandSourceStack source, @NotNull Player player, int amount, @NotNull SetType type) {
            VesselContainer vessels = VesselContainer.get(player);
            switch (type.ordinal()) {
                case 0: {
                    switch (this.set(vessels, amount, false, true)) {
                        case OK: {
                            source.sendSuccess(() -> Component.translatable((String)this.setSuccess, (Object[])new Object[]{player.getDisplayName(), amount}), true);
                            return 1;
                        }
                        case NO_CHANGE: {
                            source.sendSuccess(() -> Component.translatable((String)this.setNoChange, (Object[])new Object[]{player.getDisplayName(), amount}), true);
                            return 0;
                        }
                        case TOO_HIGH: {
                            source.sendFailure((Component)Component.translatable((String)this.setTooHigh, (Object[])new Object[]{amount}));
                            return -1;
                        }
                        case TOO_LOW: {
                            source.sendFailure((Component)Component.translatable((String)this.setTooLow, (Object[])new Object[]{amount}));
                            return -1;
                        }
                        case FAIL: {
                            source.sendFailure((Component)Component.translatable((String)this.setFail));
                            return -1;
                        }
                    }
                    break;
                }
                case 1: {
                    if (this.give(vessels, amount, true, false) != amount) {
                        source.sendFailure((Component)Component.translatable((String)this.giveFail, (Object[])new Object[]{player.getDisplayName(), amount}));
                        return 0;
                    }
                    source.sendSuccess(() -> Component.translatable((String)this.giveSuccess, (Object[])new Object[]{player.getDisplayName(), amount}), true);
                    return this.give(vessels, amount, false, true);
                }
                case 2: {
                    if (this.take(vessels, amount, true, false) != amount) {
                        source.sendFailure((Component)Component.translatable((String)this.takeFail, (Object[])new Object[]{player.getDisplayName(), amount}));
                        return 0;
                    }
                    source.sendSuccess(() -> Component.translatable((String)this.takeSuccess, (Object[])new Object[]{player.getDisplayName(), amount}), true);
                    return this.take(vessels, amount, false, true);
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @NotNull
        private VesselContainer.SetResult set(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> vessels.setHeartContainer(amount, simulate, playEffect);
                case 1 -> vessels.setStaminaVessel(amount, simulate, playEffect);
                case 2 -> vessels.setEssence(amount, simulate, playEffect);
            };
        }

        private int give(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> vessels.giveHeartContainers(amount, simulate, playEffect);
                case 1 -> vessels.giveStaminaVessels(amount, simulate, playEffect);
                case 2 -> vessels.giveEssences(amount, simulate, playEffect);
            };
        }

        private int take(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> vessels.takeHeartContainers(amount, simulate, playEffect);
                case 1 -> vessels.takeStaminaVessels(amount, simulate, playEffect);
                case 2 -> vessels.takeEssences(amount, simulate, playEffect);
            };
        }
    }
}

