/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.NeoForgeParagliderPluginLoader;
import tictim.paraglider.ParagliderCommands;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.bargain.BargainPreview;
import tictim.paraglider.api.bargain.BargainType;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.StaminaFactory;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.BargainRecipeChecker;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.config.CommonConfig;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.config.FeatureCfg;
import tictim.paraglider.config.PlayerStateMapConfig;
import tictim.paraglider.config.ServerConfig;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ParagliderVillageStructures;
import tictim.paraglider.contents.recipe.WaterBottleIngredientType;
import tictim.paraglider.impl.DefaultParagliderItemCapability;
import tictim.paraglider.impl.ParagliderCauldronInteraction;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerStateConnectionMap;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.movement.PlayerStateMapLoader;
import tictim.paraglider.impl.stamina.StaminaEfficiencyLogicHandlerImpl;
import tictim.paraglider.impl.stamina.StaminaEfficiencyLogicLoader;
import tictim.paraglider.impl.stamina.StaminaLoader;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.network.ParagliderNetworkImpl;
import tictim.paraglider.plugin.ParagliderPluginLoader;
import tictim.paraglider.wind.WindSource;
import tictim.paraglider.wind.WindSourceRegistry;

@Mod(value="paraglider")
public class ParagliderMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"Paraglider");
    private static ParagliderMod instance;
    private final CommonConfig commonCfg;
    private final Contents contents;
    private final ServerConfig config;
    private final ParagliderNetworkImpl network;
    private final NeoForgeParagliderPluginLoader pluginLoader;
    private final PlayerStateMapConfig stateMapConfig;
    private final PlayerStateConnectionMap connectionMap;
    private final WindSourceRegistry windSourceRegistry;
    @Nullable
    private final String staminaFactoryOrigin;
    @ApiStatus.Internal
    @Nullable
    public IClient client;

    @NotNull
    public static ParagliderMod instance() {
        if (instance == null) {
            throw new IllegalStateException("Mod instance not ready yet");
        }
        return instance;
    }

    public ParagliderMod(ModContainer modContainer, IEventBus eventBus) {
        if (instance != null) {
            throw new IllegalStateException("Paraglider mod instantiated twice");
        }
        instance = this;
        this.commonCfg = new CommonConfig();
        this.config = new ServerConfig();
        this.pluginLoader = new NeoForgeParagliderPluginLoader();
        this.windSourceRegistry = new WindSourceRegistry();
        this.contents = new Contents(eventBus);
        ParagliderAPI.setMovementSupplier(p -> (Movement)p.getData(Contents.get().playerMovement()));
        ParagliderAPI.setStaminaSupplier(p -> ((PlayerMovement)p.getData(Contents.get().playerMovement())).stamina());
        ParagliderAPI.setVesselContainerSupplier(p -> (VesselContainer)p.getData(Contents.get().vesselContainer()));
        Pair<PlayerStateMap, PlayerStateConnectionMap> pair = PlayerStateMapLoader.loadStates();
        this.stateMapConfig = new PlayerStateMapConfig((PlayerStateMap)pair.getFirst());
        this.connectionMap = (PlayerStateConnectionMap)pair.getSecond();
        Pair<StaminaFactory, String> pair2 = StaminaLoader.loadStaminaFactory();
        ParagliderAPI.setStaminaFactory((StaminaFactory)pair2.getFirst());
        this.staminaFactoryOrigin = (String)pair2.getSecond();
        ParagliderAPI.setStaminaEfficiencyLogicHandler(new StaminaEfficiencyLogicHandlerImpl(StaminaEfficiencyLogicLoader.loadStaminaEfficiencyLogics()));
        ParagliderAPI.setDefaultParagliderItemCapability(new DefaultParagliderItemCapability());
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.commonCfg.spec);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)this.config.spec);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.stateMapConfig.spec, "paraglider-player-states.toml");
        eventBus.addListener(event -> event.create(new RegistryBuilder(BargainPreview.TYPE_REGISTRY_KEY).sync(true)));
        eventBus.addListener(event -> {
            event.dataPackRegistry(BargainTypeRegistry.REGISTRY_KEY, BargainType.CODEC);
            event.dataPackRegistry(WindSourceRegistry.REGISTRY_KEY, WindSource.CODEC, WindSource.CODEC);
        });
        eventBus.addListener(event -> {
            event.add(EntityType.PLAYER, this.contents.maxStamina());
            event.add(EntityType.PLAYER, this.contents.staminaEfficiency());
            event.add(EntityType.PLAYER, this.contents.staminaRecovery());
            event.add(EntityType.PLAYER, this.contents.paraglidingStaminaEfficiency());
            event.add(EntityType.PLAYER, this.contents.runningStaminaEfficiency());
            event.add(EntityType.PLAYER, this.contents.swimmingStaminaEfficiency());
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            MinecraftServer server = event.getServer();
            this.stateMapConfig.removeCallbacks();
            this.stateMapConfig.reload(null);
            ParagliderUtils.printPlayerStates(this.stateMapConfig.stateMap(), this.getPlayerConnectionMap());
            this.stateMapConfig.addCallback(stateMap -> {
                ParagliderUtils.printPlayerStates(stateMap, this.getPlayerConnectionMap());
                ParagliderNetwork.get().syncStateMapToAll(server, (PlayerStateMap)stateMap);
            });
        });
        NeoForge.EVENT_BUS.addListener(event -> event.getDispatcher().register(ParagliderCommands.register()));
        NeoForge.EVENT_BUS.addListener(event -> this.stateMapConfig.removeCallbacks());
        NeoForge.EVENT_BUS.addListener(event -> {
            event.addListener((PreparableReloadListener)new WindSourceRegistry.ReloadListener(this.windSourceRegistry, event.getRegistryAccess()));
            event.addListener((PreparableReloadListener)new ParagliderVillageStructures.ReloadListener(event.getRegistryAccess()));
            event.addListener((PreparableReloadListener)new BargainRecipeChecker(event.getRegistryAccess(), event.getServerResources().getRecipeManager()));
        });
        eventBus.addListener(event -> event.enqueueWork(() -> {
            Map map = CauldronInteraction.WATER.map();
            map.put(this.contents.paraglider(), ParagliderCauldronInteraction.INSTANCE);
            map.put(this.contents.dekuLeaf(), ParagliderCauldronInteraction.INSTANCE);
        }));
        NeoForge.EVENT_BUS.addListener(event -> {
            event.getBuilder().addRecipe(new Ingredient((ICustomIngredient)WaterBottleIngredientType.INSTANCE), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), new ItemStack((ItemLike)this.contents.energizingElixir2()));
            event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{this.contents.energizingElixir2()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), new ItemStack((ItemLike)this.contents.energizingElixir3()));
            event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{this.contents.energizingElixir2()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), new ItemStack((ItemLike)this.contents.enduringElixir2()));
            event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{this.contents.enduringElixir2()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), new ItemStack((ItemLike)this.contents.enduringElixir3()));
            event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{this.contents.energizingElixir3()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), new ItemStack((ItemLike)this.contents.enduringElixir3()));
        });
        this.network = new ParagliderNetworkImpl(eventBus);
    }

    @NotNull
    public Cfg getConfig() {
        return this.config;
    }

    @NotNull
    public DebugCfg getDebugConfig() {
        return this.commonCfg;
    }

    @NotNull
    public FeatureCfg getFeatureConfig() {
        return this.commonCfg;
    }

    @NotNull
    public Contents getContents() {
        return this.contents;
    }

    @NotNull
    public ParagliderNetwork getNetwork() {
        return this.network;
    }

    @NotNull
    public ParagliderPluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    @NotNull
    public PlayerStateMap getPlayerStateMap() {
        PlayerStateMap m;
        if (this.client != null && (m = this.client.getSyncedStateMap()) != null) {
            return m;
        }
        return this.getLocalPlayerStateMap();
    }

    @NotNull
    public PlayerStateMap getLocalPlayerStateMap() {
        return this.stateMapConfig.stateMap();
    }

    @NotNull
    public PlayerStateConnectionMap getPlayerConnectionMap() {
        return this.connectionMap;
    }

    @NotNull
    public PlayerStateMapConfig getPlayerStateMapConfig() {
        return this.stateMapConfig;
    }

    @NotNull
    public WindSourceRegistry windSourceRegistry() {
        return this.windSourceRegistry;
    }

    @Nullable
    public String staminaFactoryOrigin() {
        return this.staminaFactoryOrigin;
    }

    @ApiStatus.Internal
    public static interface IClient {
        @Nullable
        public PlayerStateMap getSyncedStateMap();
    }
}

