/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderClientMod;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.ParagliderItemCapability;
import tictim.paraglider.api.movement.PlayerStateCondition;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.config.FeatureCfg;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ParagliderTags;
import tictim.paraglider.contents.recipe.QuantifiedIngredient;
import tictim.paraglider.impl.movement.PlayerStateConnectionMap;
import tictim.paraglider.impl.movement.PlayerStateMap;

public final class ParagliderUtils {
    public static final Random DIALOG_RNG = new Random();
    public static final Random PARTICLE_RNG = new Random();
    private static final AttributeModifier EXHAUSTION = new AttributeModifier(ParagliderAPI.id("exhaustion"), -0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier NO_FLIGHT = new AttributeModifier(ParagliderAPI.id("no_flight"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<BlockState>> blockStatePassThroughCache = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap m = new Object2ByteLinkedOpenHashMap();
        m.defaultReturnValue((byte)127);
        return m;
    });

    private ParagliderUtils() {
    }

    public static void giveItem(@NotNull Player player, @NotNull ItemStack stack) {
        if (player.level().isClientSide) {
            return;
        }
        while (!stack.isEmpty()) {
            int slot = player.getInventory().getSlotWithRemainingSpace(stack);
            if (slot == -1) {
                slot = player.getInventory().getFreeSlot();
            }
            if (slot == -1) {
                while (!stack.isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(0.5), player.getZ(), stack.split(stack.getMaxStackSize()));
                    itemEntity.setPickUpDelay(40);
                    itemEntity.setDeltaMovement(0.0, 0.0, 0.0);
                    player.level().addFreshEntity((Entity)itemEntity);
                }
                break;
            }
            int count = stack.getMaxStackSize() - player.getInventory().getItem(slot).getCount();
            if (!player.getInventory().add(slot, stack.split(count)) || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, slot, player.getInventory().getItem(slot)));
        }
    }

    @Nullable
    public static Item getAppropriateVessel() {
        FeatureCfg cfg = FeatureCfg.get();
        return cfg.enableHeartContainers() ? Contents.get().heartContainer() : (cfg.enableStaminaVessels() ? Contents.get().staminaVessel() : null);
    }

    public static void addExhaustion(@NotNull LivingEntity entity) {
        AttributeInstance attr = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr == null || attr.getModifier(EXHAUSTION.id()) != null) {
            return;
        }
        attr.addTransientModifier(EXHAUSTION);
    }

    public static void removeExhaustion(@NotNull LivingEntity entity) {
        AttributeInstance attr = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr == null) {
            return;
        }
        attr.removeModifier(EXHAUSTION.id());
    }

    public static void addFlyingBan(@NotNull LivingEntity entity) {
        AttributeInstance attr = entity.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (attr == null || attr.getModifier(NO_FLIGHT.id()) != null) {
            return;
        }
        attr.addTransientModifier(NO_FLIGHT);
    }

    public static void removeFlyingBan(@NotNull LivingEntity entity) {
        AttributeInstance attr = entity.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (attr == null) {
            return;
        }
        attr.removeModifier(NO_FLIGHT.id());
    }

    public static boolean giveAdvancement(@NotNull ServerPlayer player, @NotNull ResourceLocation advancementName, @NotNull String criterion) {
        PlayerAdvancements advancements = player.getAdvancements();
        ServerAdvancementManager advancementManager = player.server.getAdvancements();
        AdvancementHolder advancement = advancementManager.get(advancementName);
        return advancement != null && advancements.award(advancement, criterion);
    }

    public static boolean calculateConsumption(@NotNull QuantifiedIngredient ingredient, @NotNull Container inventory, @NotNull Int2IntOpenHashMap consumptions) {
        int amountLeft = ingredient.quantity();
        for (int i = 0; amountLeft > 0 && i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            int consumption = consumptions.get(i);
            if (consumption >= stack.getCount() || !ingredient.test(stack)) continue;
            int amountToConsume = Math.min(amountLeft, stack.getCount() - consumption);
            amountLeft -= amountToConsume;
            consumptions.put(i, consumption + amountToConsume);
        }
        return amountLeft <= 0;
    }

    public static long ms() {
        return System.nanoTime() / 1000000L;
    }

    public static void printPlayerStates(@NotNull PlayerStateMap stateMap, @NotNull PlayerStateConnectionMap connectionMap) {
        if (!DebugCfg.get().debugPlayerMovement()) {
            return;
        }
        ParagliderMod.LOGGER.debug("All Player States: {} entries{}", (Object)stateMap.states().size(), (Object)stateMap.states().values().stream().map(s -> "\n  " + String.valueOf(s.id()) + " : staminaDelta=" + s.staminaDelta() + ", recoveryDelay=" + s.recoveryDelay() + (String)(s.flags().isEmpty() ? "" : ", flags=[" + s.flags().stream().map(Object::toString).collect(Collectors.joining(", ")) + "]")).collect(Collectors.joining()));
        StringBuilder stb = new StringBuilder("All Player State Connections: ").append(connectionMap.connections().size()).append(" entries");
        for (Map.Entry<ResourceLocation, PlayerStateConnectionMap.ConnectionList> e : connectionMap.connections().entrySet()) {
            stb.append("\n  ").append(e.getKey());
            for (PlayerStateConnectionMap.Connection c : e.getValue().connections()) {
                stb.append("\n    -> ").append(c.state());
            }
            if (e.getValue().fallback() != null) {
                stb.append("\n    fallback: ").append(e.getValue().fallback());
            }
            stb.append('\n');
        }
        ParagliderMod.LOGGER.debug(stb.toString());
    }

    public static boolean canBreatheUnderwater(@NotNull Player player) {
        ItemStack feet;
        if (player.hasEffect(MobEffects.WATER_BREATHING)) {
            return true;
        }
        if (player.onGround() && (!player.canDrownInFluidType(player.getEyeInFluidType()) || player.level().getBlockState(new BlockPos((int)player.getX(), (int)player.getEyeY(), (int)player.getZ())).is(Blocks.BUBBLE_COLUMN))) {
            return true;
        }
        HolderLookup.RegistryLookup enchantments = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!head.isEmpty()) {
            if (head.getItem() == Items.TURTLE_HELMET) {
                return true;
            }
            if (head.getEnchantmentLevel((Holder)enchantments.getOrThrow(Enchantments.RESPIRATION)) > 0) {
                return true;
            }
        }
        return !(feet = player.getItemBySlot(EquipmentSlot.FEET)).isEmpty() && feet.getEnchantmentLevel((Holder)enchantments.getOrThrow(Enchantments.DEPTH_STRIDER)) > 0;
    }

    @NotNull
    public static ParagliderItemCapability getCaps(@NotNull ItemStack stack) {
        ParagliderItemCapability p = (ParagliderItemCapability)stack.getCapability(ParagliderItemCapability.CAPABILITY);
        return p != null ? p : ParagliderItemCapability.defaultImpl();
    }

    public static int countIngredient(Player player, Ingredient ingredient) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static double refreshAttribute(Player player, Holder<Attribute> attribute, double value, ResourceLocation id) {
        AttributeInstance attrib = player.getAttribute(attribute);
        if (attrib == null) {
            return 0.0;
        }
        AttributeModifier prev = attrib.getModifier(id);
        if (prev != null) {
            attrib.removeModifier(prev);
        }
        if (value != 0.0) {
            attrib.addPermanentModifier(new AttributeModifier(id, value, AttributeModifier.Operation.ADD_VALUE));
        }
        return value - (prev != null ? prev.amount() : 0.0);
    }

    public static void playParagliderDeploySound(Player player) {
        player.level().playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_EQUIP_LEATHER, SoundSource.PLAYERS, 1.0f, 0.85f);
    }

    public static boolean windCanPassThrough(Level level, BlockPos pos, BlockState state) {
        boolean canPassThrough;
        byte b;
        Object2ByteLinkedOpenHashMap<BlockState> cache;
        if (state.is(ParagliderTags.Blocks.WIND_CAN_PASS_THROUGH)) {
            return true;
        }
        if (!state.blocksMotion()) {
            return true;
        }
        VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos);
        if (shape == Shapes.block()) {
            return false;
        }
        if (shape == Shapes.empty()) {
            return true;
        }
        Object2ByteLinkedOpenHashMap<BlockState> object2ByteLinkedOpenHashMap = cache = state.getBlock().hasDynamicShape() ? null : blockStatePassThroughCache.get();
        if (cache != null && (b = cache.getAndMoveToFirst((Object)state)) != 127) {
            return b != 0;
        }
        VoxelShape[] invert = new VoxelShape[]{Shapes.empty()};
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            invert[0] = Shapes.joinUnoptimized((VoxelShape)invert[0], (VoxelShape)Shapes.box((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ), (BooleanOp)BooleanOp.OR);
        });
        boolean bl = canPassThrough = !Shapes.mergedFaceOccludes((VoxelShape)shape, (VoxelShape)invert[0], (Direction)Direction.UP) && !Shapes.mergedFaceOccludes((VoxelShape)invert[0], (VoxelShape)shape, (Direction)Direction.UP);
        if (cache != null) {
            if (cache.size() == 200) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)state, (byte)(canPassThrough ? 1 : 0));
        }
        return canPassThrough;
    }

    public static boolean canUseParaglider(PlayerStateCondition.Context context) {
        return context.player().isCreative() || !context.stamina().isDepleted() || context.canDoPanicParagliding();
    }

    public static boolean renderStaminaWheel(@Nullable Player player) {
        if (ParagliderClientMod.instance().removeStaminaWheel()) {
            return false;
        }
        return player == null || Stamina.get(player).renderStaminaWheel();
    }
}

