/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.ParagliderItemCapability;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogicHandler;
import tictim.paraglider.api.stamina.StaminaFactory;
import tictim.paraglider.api.vessel.VesselContainer;

public class ParagliderAPI {
    public static final String MODID = "paraglider";
    public static final TagKey<Item> PARAGLIDERS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ParagliderAPI.id("paragliders"));
    public static final TagKey<Block> WIND_CAN_PASS_THROUGH = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ParagliderAPI.id("wind_can_pass_through"));
    private static @Nullable Function<@NotNull Player, @NotNull Movement> movementSupplier;
    private static @Nullable Function<@NotNull Player, @NotNull Stamina> staminaSupplier;
    private static @Nullable Function<@NotNull Player, @NotNull VesselContainer> vesselContainerSupplier;
    @Nullable
    private static StaminaFactory staminaFactory;
    @Nullable
    private static ParagliderItemCapability defaultParagliderItemCapability;
    @Nullable
    private static StaminaEfficiencyLogicHandler staminaEfficiencyLogicHandler;

    @NotNull
    public static ResourceLocation id(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @ApiStatus.Internal
    @NotNull
    public static Function<Player, Movement> movementSupplier() {
        if (movementSupplier != null) {
            return movementSupplier;
        }
        throw new IllegalStateException("movementSupplier is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static Function<Player, Stamina> staminaSupplier() {
        if (staminaSupplier != null) {
            return staminaSupplier;
        }
        throw new IllegalStateException("staminaSupplier is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static Function<Player, VesselContainer> vesselContainerSupplier() {
        if (vesselContainerSupplier != null) {
            return vesselContainerSupplier;
        }
        throw new IllegalStateException("vesselContainerSupplier is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static StaminaFactory staminaFactory() {
        if (staminaFactory != null) {
            return staminaFactory;
        }
        throw new IllegalStateException("staminaFactory is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static ParagliderItemCapability defaultParagliderItemCapability() {
        if (defaultParagliderItemCapability != null) {
            return defaultParagliderItemCapability;
        }
        throw new IllegalStateException("defaultParagliderItemCapability is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static StaminaEfficiencyLogicHandler staminaEfficiencyLogicHandler() {
        if (staminaEfficiencyLogicHandler != null) {
            return staminaEfficiencyLogicHandler;
        }
        throw new IllegalStateException("staminaEfficiencyLogicHandler is not available yet");
    }

    @ApiStatus.Internal
    public static void setMovementSupplier(@NotNull Function<Player, Movement> supplier) {
        Objects.requireNonNull(supplier);
        if (movementSupplier != null) {
            throw new IllegalStateException("Trying to set movementSupplier twice");
        }
        movementSupplier = supplier;
    }

    @ApiStatus.Internal
    public static void setStaminaSupplier(@NotNull Function<Player, Stamina> supplier) {
        Objects.requireNonNull(supplier);
        if (staminaSupplier != null) {
            throw new IllegalStateException("Trying to set staminaSupplier twice");
        }
        staminaSupplier = supplier;
    }

    @ApiStatus.Internal
    public static void setVesselContainerSupplier(@NotNull Function<Player, VesselContainer> supplier) {
        Objects.requireNonNull(supplier);
        if (vesselContainerSupplier != null) {
            throw new IllegalStateException("Trying to set vesselContainerSupplier twice");
        }
        vesselContainerSupplier = supplier;
    }

    @ApiStatus.Internal
    public static void setStaminaFactory(@NotNull StaminaFactory staminaFactory) {
        Objects.requireNonNull(staminaFactory);
        if (ParagliderAPI.staminaFactory != null) {
            throw new IllegalStateException("Trying to set staminaFactory twice");
        }
        ParagliderAPI.staminaFactory = staminaFactory;
    }

    @ApiStatus.Internal
    public static void setDefaultParagliderItemCapability(@Nullable ParagliderItemCapability c) {
        Objects.requireNonNull(c);
        if (defaultParagliderItemCapability != null) {
            throw new IllegalStateException("Trying to set defaultParagliderItemCapability twice");
        }
        defaultParagliderItemCapability = c;
    }

    @ApiStatus.Internal
    public static void setStaminaEfficiencyLogicHandler(StaminaEfficiencyLogicHandler h) {
        Objects.requireNonNull(h);
        if (staminaEfficiencyLogicHandler != null) {
            throw new IllegalStateException("Trying to set staminaEfficiencyLogicHandler twice");
        }
        staminaEfficiencyLogicHandler = h;
    }
}

