/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.bargain;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record BargainDialog(@NotNull @NotNull @Unmodifiable List<@NotNull Dialog> initialDialog, @Nullable Dialog initialDialogFallback, @NotNull @NotNull @Unmodifiable List<@NotNull Dialog> successDialog, @Nullable Dialog successDialogFallback, @NotNull @NotNull @Unmodifiable List<@NotNull Dialog> failDialog, @Nullable Dialog failDialogFallback) {
    public static final BargainDialog EMPTY = new BargainDialog(List.of(), null, List.of(), null, List.of(), null);
    public static final Codec<BargainDialog> CODEC = RecordCodecBuilder.create(b -> b.group((App)Dialog.CODEC.listOf().fieldOf("initial").forGetter(BargainDialog::initialDialog), (App)Dialog.CODEC.optionalFieldOf("initial_fallback").forGetter(d -> Optional.ofNullable(d.initialDialogFallback)), (App)Dialog.CODEC.listOf().fieldOf("success").forGetter(BargainDialog::successDialog), (App)Dialog.CODEC.optionalFieldOf("success_fallback").forGetter(d -> Optional.ofNullable(d.successDialogFallback)), (App)Dialog.CODEC.listOf().fieldOf("fail").forGetter(BargainDialog::failDialog), (App)Dialog.CODEC.optionalFieldOf("fail_fallback").forGetter(d -> Optional.ofNullable(d.failDialogFallback))).apply((Applicative)b, (initialDialog, initialDialogFallback, successDialog, successDialogFallback, failDialog, failDialogFallback) -> new BargainDialog((List<Dialog>)initialDialog, initialDialogFallback.orElse(null), (List<Dialog>)successDialog, successDialogFallback.orElse(null), (List<Dialog>)failDialog, failDialogFallback.orElse(null))));

    public BargainDialog(@NotNull @NotNull List<@NotNull Dialog> initialDialog, @Nullable Dialog initialDialogFallback, @NotNull @NotNull List<@NotNull Dialog> successDialog, @Nullable Dialog successDialogFallback, @NotNull @NotNull List<@NotNull Dialog> failDialog, @Nullable Dialog failDialogFallback) {
        this.initialDialog = initialDialog.stream().filter(dialog -> dialog.weight > 0).toList();
        this.initialDialogFallback = initialDialogFallback;
        this.successDialog = successDialog.stream().filter(dialog -> dialog.weight > 0).toList();
        this.successDialogFallback = successDialogFallback;
        this.failDialog = failDialog.stream().filter(dialog -> dialog.weight > 0).toList();
        this.failDialogFallback = failDialogFallback;
    }

    @Nullable
    public Component randomInitialDialog(@NotNull Random random) {
        return this.randomDialog(this.initialDialog, this.initialDialogFallback, random, null, null);
    }

    @Nullable
    public Component randomSuccessDialog(@NotNull Random random, @NotNull Set<String> tags) {
        return this.randomDialog(this.successDialog, this.successDialogFallback, random, Objects.requireNonNull(tags), null);
    }

    @Nullable
    public Component randomFailDialog(@NotNull Random random, @NotNull Set<String> tags, @NotNull Set<String> failReasons) {
        return this.randomDialog(this.failDialog, this.failDialogFallback, random, Objects.requireNonNull(tags), Objects.requireNonNull(failReasons));
    }

    @Nullable
    private Component randomDialog(@NotNull List<Dialog> dialogs, @Nullable Dialog fallback, @NotNull Random random, @Nullable Set<String> tags, @Nullable Set<String> failReasons) {
        long weightSum = 0L;
        IntArrayList indices = new IntArrayList();
        for (int i = 0; i < dialogs.size(); ++i) {
            Dialog dialog = dialogs.get(i);
            if (tags != null && dialog.tagFilter != null && !tags.containsAll(dialog.tagFilter) || failReasons != null && dialog.failReasonFilter != null && !failReasons.containsAll(dialog.failReasonFilter)) continue;
            indices.add(i);
            weightSum += (long)dialog.weight;
        }
        if (weightSum > 0L) {
            long weight = random.nextLong(weightSum);
            for (int i = 0; i < indices.size(); ++i) {
                Dialog dialog = dialogs.get(indices.getInt(i));
                if ((weight -= (long)dialog.weight) >= 0L) continue;
                return dialog.text;
            }
        }
        return fallback == null ? null : fallback.text;
    }

    public record Dialog(@NotNull Component text, int weight, @Nullable @Unmodifiable Set<@NotNull String> tagFilter, @Nullable @Unmodifiable Set<@NotNull String> failReasonFilter) {
        public static final Codec<Dialog> CODEC = RecordCodecBuilder.create((T b) -> b.group((App)ComponentSerialization.CODEC.fieldOf("dialog").forGetter(d -> d.text), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(d -> d.weight), (App)Codec.STRING.listOf().optionalFieldOf("tag", List.of()).forGetter(d -> d.tagFilter == null ? List.of() : List.copyOf(d.tagFilter)), (App)Codec.STRING.listOf().optionalFieldOf("reason", List.of()).forGetter(d -> d.failReasonFilter == null ? List.of() : List.copyOf(d.failReasonFilter))).apply((Applicative)b, (text, weight, tagFilter, reasonFilter) -> new Dialog((Component)text, (int)weight, Set.copyOf(tagFilter), Set.copyOf(reasonFilter))));

        @NotNull
        public static Dialog create(@NotNull String translateKey) {
            return Dialog.create(translateKey, 1);
        }

        @NotNull
        public static Dialog create(@NotNull String translateKey, int weight) {
            return new Dialog((Component)Component.translatable((String)Objects.requireNonNull(translateKey)), weight, null, null);
        }

        @NotNull
        public static Dialog createForTag(@NotNull String translateKey, String ... tags) {
            return Dialog.createForTag(translateKey, 1, tags);
        }

        @NotNull
        public static Dialog createForTag(@NotNull String translateKey, int weight, String ... tags) {
            return new Dialog((Component)Component.translatable((String)Objects.requireNonNull(translateKey)), weight, tags.length == 0 ? null : Set.of(tags), null);
        }

        @NotNull
        public static Dialog createForFailReason(@NotNull String translateKey, String ... failReasons) {
            return Dialog.createForFailReason(translateKey, 1, failReasons);
        }

        @NotNull
        public static Dialog createForFailReason(@NotNull String translateKey, int weight, String ... failReasons) {
            return new Dialog((Component)Component.translatable((String)Objects.requireNonNull(translateKey)), weight, null, failReasons.length == 0 ? null : Set.of(failReasons));
        }
    }
}

