/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.movement;

import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.ParagliderPlayerStates;

public interface PlayerState {
    @NotNull
    public ResourceLocation id();

    @NotNull
    public @NotNull @Unmodifiable Set<@NotNull ResourceLocation> flags();

    public double staminaDelta();

    public @Range(from=0L, to=0x7FFFFFFFL) int recoveryDelay();

    default public boolean is(@NotNull ResourceLocation id) {
        Objects.requireNonNull(id, "id == null");
        return this.id().equals((Object)id);
    }

    default public boolean hasFlag(@NotNull ResourceLocation flag) {
        Objects.requireNonNull(flag, "flag == null");
        return this.flags().contains(flag);
    }

    default public boolean paragliding() {
        return this.hasFlag(ParagliderPlayerStates.Flags.PARAGLIDING);
    }
}

