/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.client.render.StaminaWheelConstants;

public class EffectTimer {
    private final long finishAt;
    private boolean active;
    private long activeTime;
    private long activeDuration;

    public EffectTimer(long finishAt) {
        this.finishAt = finishAt;
    }

    public EffectTimer() {
        this(-1L);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive() {
        this.setActive(0L);
    }

    public void setActive(long activeDuration) {
        this.active = true;
        this.activeTime = ParagliderUtils.ms() - activeDuration;
        this.activeDuration = activeDuration;
    }

    public long activeTime() {
        return this.activeTime;
    }

    public long activeDuration() {
        return this.activeDuration;
    }

    public void setActiveDuration(long activeDuration) {
        this.activeDuration = activeDuration;
    }

    public int getGlowAndFadeColor(int baseColor) {
        return this.active ? StaminaWheelConstants.getGlowAndFadeColor(this.activeDuration, baseColor) : baseColor;
    }

    public int getGlowColor(int baseColor) {
        return this.active ? StaminaWheelConstants.getGlowColor(this.activeDuration, baseColor) : baseColor;
    }

    public int getFadeColor(int baseColor) {
        return this.active ? StaminaWheelConstants.getFadeColor(this.activeDuration, baseColor) : baseColor;
    }

    public void update(boolean active) {
        this.update(active ? UpdateMode.RETAIN_ACTIVE : UpdateMode.SET_INACTIVE);
    }

    public void update(@NotNull UpdateMode active) {
        switch (active.ordinal()) {
            case 1: {
                if (this.active) {
                    this.updateActiveDuration();
                    return;
                }
            }
            case 0: {
                this.active = true;
                this.activeTime = ParagliderUtils.ms();
                this.activeDuration = 0L;
                return;
            }
            case 2: {
                this.active = false;
                this.activeTime = 0L;
                this.activeDuration = 0L;
                return;
            }
            case 3: {
                if (!this.active) break;
                this.updateActiveDuration();
            }
        }
    }

    private void updateActiveDuration() {
        this.activeDuration = ParagliderUtils.ms() - this.activeTime;
        if (this.finishAt >= 0L && this.activeDuration > this.finishAt) {
            this.active = false;
            this.activeTime = 0L;
            this.activeDuration = 0L;
        }
    }

    public void reset() {
        this.active = false;
        this.activeTime = 0L;
        this.activeDuration = 0L;
    }

    public static enum UpdateMode {
        SET_ACTIVE,
        RETAIN_ACTIVE,
        SET_INACTIVE,
        RETAIN;

    }
}

