/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.client.render.EffectTimer;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.settings.ExtraWheelAttachment;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.contents.ParagliderTags;

public abstract class StaminaWheelRenderer {
    private static final DecimalFormat DEBUG = new DecimalFormat("#.00");
    private static final Style SMALL_NUMBER_STYLE = Style.EMPTY.withFont(ParagliderAPI.id("small_numbers"));
    private static final int FONT_HEIGHT = 7;
    protected final Wheel mainWheel = new Wheel();
    protected final Wheel extraWheel = new Wheel();
    private boolean debug;
    @Nullable
    private List<EffectTimer> debugAnims;
    @Nullable
    private List<String> debugAnimNames;
    @Nullable
    private FloatList debugVertices;
    private static final float[] edgePoints = new float[]{0.0f, 0.125f, 0.375f, 0.625f, 0.875f, 1.0f};

    public void render(@NotNull GuiGraphics guiGraphics, float x, float y, float z, float partialTicks, @Nullable ExtraWheelAttachment extraWheelAttachment) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        this.debug = this.isDebugEnabled((Player)player);
        this.makeWheel((Player)player, partialTicks);
        this.render(guiGraphics, x, y, z, this.isDebugEnabled((Player)player), extraWheelAttachment);
        this.mainWheel.reset();
        this.extraWheel.reset();
        if (this.debug) {
            this.debug = false;
            if (this.debugAnims != null) {
                this.debugAnims.clear();
            }
            if (this.debugAnimNames != null) {
                this.debugAnimNames.clear();
            }
            if (this.debugVertices != null) {
                this.debugVertices.clear();
            }
        }
    }

    protected boolean isDebugEnabled(@NotNull Player player) {
        return DebugCfg.get().debugPlayerMovement() && player.getOffhandItem().is(ParagliderTags.PARAGLIDERS);
    }

    protected void debugAnim(String name, EffectTimer anim) {
        if (!this.debug) {
            return;
        }
        if (this.debugAnims == null) {
            this.debugAnims = new ArrayList<EffectTimer>();
        }
        if (this.debugAnimNames == null) {
            this.debugAnimNames = new ArrayList<String>();
        }
        this.debugAnims.add(anim);
        this.debugAnimNames.add(name);
    }

    protected abstract void makeWheel(@NotNull Player var1, float var2);

    protected void render(@NotNull GuiGraphics guiGraphics, float x, float y, float z, boolean debug, @Nullable ExtraWheelAttachment extraWheelAttachment) {
        Object s;
        int i;
        if (debug) {
            int i2;
            Font font = Minecraft.getInstance().font;
            int lines = 0;
            if (this.debugAnimNames != null && this.debugAnims != null) {
                for (i = 0; i < this.debugAnimNames.size(); ++i) {
                    String name = this.debugAnimNames.get(i);
                    EffectTimer anim = this.debugAnims.get(i);
                    String string = name + ": " + (String)(anim.isActive() ? "active " + anim.activeDuration() : "inactive");
                    Objects.requireNonNull(font);
                    guiGraphics.drawString(font, string, 20, 10 + 9 * lines++, -1);
                }
            }
            if (lines > 0) {
                ++lines;
            }
            int lineStart = lines;
            int maxWidth = 0;
            for (i2 = 0; i2 < this.mainWheel.count; ++i2) {
                s = this.mainWheel.segments.get(i2);
                String segmentString = DEBUG.format(((Wheel.Segment)s).from) + " ~ " + DEBUG.format(((Wheel.Segment)s).to) + ": ";
                Objects.requireNonNull(font);
                guiGraphics.drawString(font, segmentString, 20, 10 + 9 * lines++, -1);
                maxWidth = Math.max(maxWidth, font.width(segmentString));
            }
            lines = lineStart;
            for (i2 = 0; i2 < this.mainWheel.count; ++i2) {
                s = this.mainWheel.segments.get(i2);
                String string = String.format("#%X", ((Wheel.Segment)s).color);
                Objects.requireNonNull(font);
                guiGraphics.drawString(font, string, 20 + maxWidth, 10 + 9 * lines++, FastColor.ARGB32.color((int)Math.max(255, FastColor.ARGB32.alpha((int)((Wheel.Segment)s).color) * 2), (int)((Wheel.Segment)s).color));
            }
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(x, y, z);
        this.drawWheels(guiGraphics, extraWheelAttachment);
        if (this.debugVertices != null) {
            Font font = Minecraft.getInstance().font;
            for (i = 0; i < this.debugVertices.size(); i += 2) {
                float f;
                float vx = this.debugVertices.getFloat(i);
                float vy = this.debugVertices.getFloat(i + 1);
                s = DEBUG.format(vx) + " " + DEBUG.format(vy);
                Vector2f v2 = new Vector2f(vx, vy).normalize().mul(20.0f);
                int n = (int)(vx > 0.0f ? v2.x : v2.x - (float)font.width((String)s));
                if (vy > 0.0f) {
                    float f2 = -v2.y;
                    Objects.requireNonNull(font);
                    f = f2 - 9.0f;
                } else {
                    f = -v2.y;
                }
                guiGraphics.drawString(font, (String)s, n, (int)f, StaminaWheelConstants.wheelColor(0));
            }
        }
        pose.popPose();
    }

    protected void drawWheels(@NotNull GuiGraphics guiGraphics, @Nullable ExtraWheelAttachment extraWheelAttachment) {
        int color;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawWheel(guiGraphics, this.mainWheel, WheelLevel.FIRST, 10.0f);
        this.drawWheel(guiGraphics, this.mainWheel, WheelLevel.SECOND, 10.0f);
        this.drawWheel(guiGraphics, this.mainWheel, WheelLevel.THIRD, 10.0f);
        guiGraphics.flush();
        if (this.extraWheel.stamina() > 0.0 && extraWheelAttachment != null) {
            PoseStack pose = guiGraphics.pose();
            int wheels = Math.min(3, (int)Math.ceil(StaminaWheelConstants.toWheelPos(this.mainWheel.maxStamina)) - 1);
            boolean hasTwoExtraWheels = this.extraWheel.stamina > 1000.0;
            pose.pushPose();
            pose.translate(this.extraWheelOffsetX(extraWheelAttachment, wheels, hasTwoExtraWheels, 0), this.extraWheelOffsetY(extraWheelAttachment, wheels, hasTwoExtraWheels, 0), 0.0);
            this.drawWheel(guiGraphics, this.extraWheel, WheelLevel.EXTRA_1, 5.0f);
            pose.popPose();
            if (hasTwoExtraWheels) {
                pose.pushPose();
                pose.translate(this.extraWheelOffsetX(extraWheelAttachment, wheels, true, 1), this.extraWheelOffsetY(extraWheelAttachment, wheels, true, 1), 0.0);
                this.drawWheel(guiGraphics, this.extraWheel, WheelLevel.EXTRA_2, 5.0f);
                pose.popPose();
            }
        }
        if (FastColor.ARGB32.alpha((int)(color = this.mainWheel.indicatorColor())) >= 4) {
            this.drawText(guiGraphics, "+" + Math.max(1, (int)(Math.ceil(this.mainWheel.staminaWheelPos()) - 3.0)), false, 9, -9, color);
        }
        if (this.extraWheel.stamina() > 2000.0 && extraWheelAttachment != null && FastColor.ARGB32.alpha((int)(color = this.extraWheel.indicatorColor())) >= 4) {
            this.drawText(guiGraphics, "+" + Math.max(1, (int)(Math.ceil(StaminaWheelConstants.toWheelPos(this.extraWheel.stamina())) - 2.0)), true, -9, -9, color);
        }
        RenderSystem.disableBlend();
    }

    protected double extraWheelOffsetX(ExtraWheelAttachment extraWheelAttachment, int wheels, boolean hasTwoExtraWheels, int index) {
        double extraWheelMargin = 12.5;
        return switch (extraWheelAttachment) {
            default -> throw new MatchException(null, null);
            case ExtraWheelAttachment.TOP, ExtraWheelAttachment.BOTTOM -> {
                if (!hasTwoExtraWheels) {
                    yield 0.0;
                }
                yield (index == 0 ? 0.5 : -0.5) * 12.5;
            }
            case ExtraWheelAttachment.LEFT, ExtraWheelAttachment.RIGHT -> {
                double offset = (double)(-15 - wheels) - 0.5;
                if (index == 1) {
                    offset -= 12.5;
                }
                if (extraWheelAttachment == ExtraWheelAttachment.RIGHT) {
                    offset = -offset;
                }
                yield offset;
            }
        };
    }

    protected double extraWheelOffsetY(ExtraWheelAttachment extraWheelAttachment, int wheels, boolean hasTwoExtraWheels, int index) {
        return switch (extraWheelAttachment) {
            default -> throw new MatchException(null, null);
            case ExtraWheelAttachment.LEFT, ExtraWheelAttachment.RIGHT -> 0.0;
            case ExtraWheelAttachment.TOP, ExtraWheelAttachment.BOTTOM -> {
                double offset = (double)(-15 - wheels) - 0.5;
                if (hasTwoExtraWheels) {
                    offset += 2.0;
                }
                if (extraWheelAttachment == ExtraWheelAttachment.BOTTOM) {
                    offset = -offset;
                }
                yield offset;
            }
        };
    }

    protected void drawText(GuiGraphics guiGraphics, String text, boolean alignRight, int x, int y, int color) {
        Font font = Minecraft.getInstance().font;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(0.5f, 0.5f, 1.0f);
        MutableComponent component = Component.literal((String)text).setStyle(SMALL_NUMBER_STYLE);
        guiGraphics.drawString(font, (Component)component, alignRight ? -font.width((FormattedText)component) : 0, -3, color);
        pose.popPose();
    }

    protected void drawWheel(GuiGraphics guiGraphics, Wheel wheel, WheelLevel wheelLevel, float radius) {
        float wheelStart = switch (wheelLevel.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.0f;
            case 1 -> 1.0f;
            case 2 -> Math.max(2.0f, (float)Math.ceil(wheel.staminaWheelPos()) - 1.0f);
            case 3 -> (float)Math.ceil(wheel.staminaWheelPos()) - 1.0f;
            case 4 -> (float)Math.ceil(wheel.staminaWheelPos()) - 2.0f;
        };
        for (int i = 0; i < wheel.count; ++i) {
            float end;
            float start;
            Wheel.Segment segment = wheel.segments.get(i);
            int alpha = FastColor.ARGB32.alpha((int)segment.color);
            if (alpha <= 0 || (start = segment.from - wheelStart) >= 1.0f || (end = segment.to - wheelStart) <= 0.0f) continue;
            this.drawSegment(guiGraphics, wheelLevel, start, end, segment.color, radius);
        }
    }

    protected void drawSegment(GuiGraphics guiGraphics, WheelLevel wheelLevel, float start, float end, int color, float radius) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)wheelLevel.texture);
        BufferBuilder b = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX_COLOR);
        b.addVertex(guiGraphics.pose().last(), 0.0f, 0.0f, 0.0f).setUv(0.5f, 0.5f).setColor(color);
        int edgeIndex = 0;
        int segmentIndex = 0;
        while (edgeIndex < edgePoints.length && segmentIndex < 2) {
            float currentEdge;
            float currentSegment = segmentIndex == 0 ? start : end;
            if (currentSegment <= (currentEdge = edgePoints[edgeIndex])) {
                if (currentSegment > 0.0f) {
                    this.vert(guiGraphics, (VertexConsumer)b, currentSegment, radius, color);
                }
                ++segmentIndex;
                continue;
            }
            if (segmentIndex > 0) {
                this.vert(guiGraphics, (VertexConsumer)b, currentEdge, radius, color);
            }
            ++edgeIndex;
        }
        BufferUploader.drawWithShader((MeshData)b.buildOrThrow());
    }

    protected void vert(GuiGraphics guiGraphics, VertexConsumer vc, float point, float radius, int color) {
        float vy;
        float vx;
        float PI = (float)Math.PI;
        if (point == 0.0f || point == 1.0f) {
            vx = 0.0f;
            vy = 1.0f;
        } else if ((double)point == 0.125) {
            vx = -1.0f;
            vy = 1.0f;
        } else if ((double)point == 0.375) {
            vx = -1.0f;
            vy = -1.0f;
        } else if ((double)point == 0.625) {
            vx = 1.0f;
            vy = -1.0f;
        } else if ((double)point == 0.875) {
            vx = 1.0f;
            vy = 1.0f;
        } else if ((double)point < 0.125 || (double)point > 0.875) {
            vx = (float)(-Math.tan(point * ((float)Math.PI * 2)));
            vy = 1.0f;
        } else if ((double)point < 0.375) {
            vx = -1.0f;
            vy = 1.0f / (float)Math.tan(point * ((float)Math.PI * 2));
        } else if ((double)point < 0.625) {
            vx = (float)Math.tan(point * ((float)Math.PI * 2));
            vy = -1.0f;
        } else {
            vx = 1.0f;
            vy = -1.0f / (float)Math.tan(point * ((float)Math.PI * 2));
        }
        vc.addVertex(guiGraphics.pose().last(), vx * radius, vy * -radius, 0.0f).setUv((float)((double)(vx / 2.0f) + 0.5), (float)((double)(vy / 2.0f) + 0.5)).setColor(color);
        if (this.debug) {
            if (this.debugVertices == null) {
                this.debugVertices = new FloatArrayList();
            }
            this.debugVertices.add(vx);
            this.debugVertices.add(vy);
        }
    }

    public static final class Wheel {
        private final List<Segment> segments = new ArrayList<Segment>();
        private double stamina;
        private double maxStamina;
        private int count;
        private int indicatorColor;

        public double stamina() {
            return this.stamina;
        }

        public double maxStamina() {
            return this.maxStamina;
        }

        public void setProperties(double stamina, double maxStamina) {
            this.stamina = stamina;
            this.maxStamina = maxStamina;
        }

        public int indicatorColor() {
            return this.indicatorColor;
        }

        public void setIndicatorColor(int indicatorColor) {
            this.indicatorColor = indicatorColor;
        }

        public float staminaWheelPos() {
            return StaminaWheelConstants.toWheelPos((int)Math.min(this.maxStamina(), this.stamina()));
        }

        public void fillStamina(double from, double to, int color) {
            this.fillWheel(StaminaWheelConstants.toWheelPos(Math.clamp(from, 0.0, this.maxStamina)), StaminaWheelConstants.toWheelPos(Math.clamp(to, 0.0, this.maxStamina)), color);
        }

        public void fillWheel(float from, float to, int color) {
            if ((from = Math.max(0.0f, from)) < to) {
                this.insert(this.searchForBaseSegment(from), from, to, color);
            }
        }

        private int searchForBaseSegment(float from) {
            int l = 0;
            int r = this.count;
            while (l < r) {
                int m = l + (r - l) / 2;
                Segment s = this.segments.get(m);
                if (s.from < from) {
                    l = m + 1;
                    continue;
                }
                r = m;
            }
            return l;
        }

        private void insert(int index, float from, float to, int color) {
            int lastIndex;
            Segment s;
            for (int i = index; i < this.count; ++i) {
                s = this.segments.get(i);
                if (s.from < from) {
                    ++index;
                    s.to = from;
                    continue;
                }
                if (s.to <= to) {
                    this.removeSegment(i--);
                    continue;
                }
                s.from = to;
                break;
            }
            s = (lastIndex = this.segments.size() - 1) > this.count ? this.segments.remove(lastIndex) : new Segment();
            s.from = from;
            s.to = to;
            s.color = color;
            this.segments.add(index, s);
            ++this.count;
        }

        private void removeSegment(int index) {
            this.segments.add(this.segments.remove(index));
            --this.count;
        }

        public void reset() {
            this.count = 0;
            this.maxStamina = 0.0;
            this.indicatorColor = 0;
        }

        private static final class Segment {
            private float from;
            private float to;
            private int color;

            private Segment() {
            }

            public String toString() {
                return String.format("%s ~ %s: #%X", DEBUG.format(this.from), DEBUG.format(this.to), this.color);
            }
        }
    }

    public static enum WheelLevel {
        FIRST(ParagliderAPI.id("textures/stamina/first.png")),
        SECOND(ParagliderAPI.id("textures/stamina/second.png")),
        THIRD(ParagliderAPI.id("textures/stamina/third.png")),
        EXTRA_1(ParagliderAPI.id("textures/stamina/extra.png")),
        EXTRA_2(WheelLevel.EXTRA_1.texture);

        public final ResourceLocation texture;

        private WheelLevel(ResourceLocation texture) {
            this.texture = Objects.requireNonNull(texture);
        }
    }
}

