/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderClientMod;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.client.screen.StaminaWheelSettingScreen;
import tictim.paraglider.client.settings.ParagliderClientSettings;
import tictim.paraglider.client.settings.ParagliderClientSettingsIO;

public class ParagliderSettingsScreen
extends Screen {
    private final Component saveButtonText = Component.translatable((String)"paraglider.settings.save");
    private final Component saveButtonTextUnsaved = Component.translatable((String)"paraglider.settings.save.unsaved");
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    @Nullable
    private ParticleSliderWidget particleSliderWidget;
    @Nullable
    private Button saveSettingsButton;
    @Nullable
    private SaveLoadAction saveLoadAction;

    public ParagliderSettingsScreen() {
        super((Component)Component.empty());
    }

    public void saveSettings() {
        ParagliderClientSettings currentSettings;
        ParagliderClientSettings newSettings = currentSettings = ParagliderClientSettings.get();
        if (this.particleSliderWidget != null && this.particleSliderWidget.dirty) {
            newSettings = new ParagliderClientSettings(currentSettings.staminaWheelPosition(), this.particleSliderWidget.value(), currentSettings.extraWheelAttachment());
            this.particleSliderWidget.dirty = false;
        }
        ParagliderClientMod.instance().setSettings(newSettings);
        SaveLoadAction saveLoadAction = new SaveLoadAction(false, null);
        ParagliderClientSettingsIO.save(newSettings, saveLoadAction::notifySaveResult);
        this.saveLoadAction = saveLoadAction;
    }

    public void loadSettings() {
        this.enableWidgets(false);
        SaveLoadAction saveLoadAction = new SaveLoadAction(true, b -> this.enableWidgets(true));
        ParagliderClientSettingsIO.load(saveLoadAction::notifySaveResult);
        this.saveLoadAction = saveLoadAction;
    }

    private void enableWidgets(boolean enabled) {
        for (AbstractWidget widget : this.widgets) {
            widget.active = enabled;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void init() {
        Button staminaWheelSettingsButton = Button.builder((Component)Component.translatable((String)"paraglider.settings.stamina_wheel_settings"), b -> Objects.requireNonNull(this.minecraft).setScreen((Screen)new StaminaWheelSettingScreen(this))).size(128, 20).build();
        this.widgets.clear();
        this.widgets.add((AbstractWidget)staminaWheelSettingsButton);
        this.particleSliderWidget = new ParticleSliderWidget(128, 20, this.particleSliderWidget);
        this.widgets.add((AbstractWidget)this.particleSliderWidget);
        int totalHeight = (this.widgets.size() - 1) * 10;
        for (AbstractWidget abstractWidget : this.widgets) {
            totalHeight += abstractWidget.getHeight();
        }
        int y = (this.height - totalHeight) / 2;
        for (AbstractWidget w : this.widgets) {
            w.setX((this.width - w.getWidth()) / 2);
            w.setY(y);
            y += w.getHeight() + 10;
        }
        this.saveSettingsButton = Button.builder((Component)this.saveButtonText, b -> this.saveSettings()).bounds(this.width - 128 - 10, this.height - 20 - 10 - 20 - 10 - 20 - 10, 128, 20).build();
        this.widgets.add((AbstractWidget)this.saveSettingsButton);
        this.widgets.add((AbstractWidget)Button.builder((Component)Component.translatable((String)"paraglider.settings.open_folder"), b -> Util.getPlatform().openUri(ParagliderClientSettingsIO.FILEPATH.getParent().toUri())).bounds(this.width - 128 - 10, this.height - 20 - 10 - 20 - 10, 128, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"paraglider.settings.open_folder.tooltip"))).build());
        this.widgets.add((AbstractWidget)Button.builder((Component)Component.translatable((String)"paraglider.settings.reload"), b -> this.loadSettings()).bounds(this.width - 128 - 10, this.height - 20 - 10, 128, 20).build());
        for (AbstractWidget widget : this.widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
        if (!ParagliderUtils.renderStaminaWheel((Player)Objects.requireNonNull(this.minecraft).player)) {
            void var4_10;
            String string;
            staminaWheelSettingsButton.active = false;
            String string2 = string = ParagliderClientMod.instance().removeStaminaWheel() ? ParagliderClientMod.instance().staminaWheelRemoverId() : ParagliderMod.instance().staminaFactoryOrigin();
            if (string == null) {
                String string3 = "(unknown)";
            }
            staminaWheelSettingsButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"paraglider.settings.stamina_wheel_settings.disabled", (Object[])new Object[]{var4_10})));
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.saveSettingsButton != null) {
            this.saveSettingsButton.setMessage(this.particleSliderWidget != null && this.particleSliderWidget.dirty ? this.saveButtonTextUnsaved : this.saveButtonText);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.saveLoadAction != null) {
            int alpha;
            this.saveLoadAction.update();
            int n = alpha = !this.saveLoadAction.isComplete() ? 255 : BargainScreen.getDialogAlpha(ParagliderUtils.ms() - this.saveLoadAction.saveCompleteTimestamp);
            if (alpha == 0) {
                this.saveLoadAction = null;
            } else {
                Component component = this.saveLoadAction.text();
                Objects.requireNonNull(this.font);
                graphics.drawString(this.font, component, 5, this.height - 9 - 5, alpha << 24 | 0xFFFFFF, true);
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) || ParagliderClientMod.instance().getParagliderSettingsKey().getKey().equals((Object)mouseKey)) {
            this.onClose();
            return true;
        }
        return false;
    }

    private static final class ParticleSliderWidget
    extends AbstractSliderButton {
        private boolean dirty;
        private static final DecimalFormat fmt = new DecimalFormat("0%");

        public ParticleSliderWidget(int width, int height, @Nullable ParticleSliderWidget prevInstance) {
            super(0, 0, width, height, (Component)Component.empty(), 0.0);
            if (prevInstance != null) {
                this.setTooltip(prevInstance.getTooltip());
                this.setMessage(prevInstance.getMessage());
                this.value = prevInstance.value;
                this.dirty = prevInstance.dirty;
            } else {
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)"paraglider.settings.wind_particle_freq.tooltip")));
                this.value = ParagliderClientSettings.get().windParticleFrequency();
                this.setMessage(ParticleSliderWidget.message(this.value));
                this.dirty = false;
            }
        }

        public double value() {
            return this.value;
        }

        protected void updateMessage() {
            this.setMessage(ParticleSliderWidget.message(this.value));
        }

        protected void applyValue() {
            this.dirty = true;
        }

        private static Component message(double value) {
            return Component.translatable((String)"paraglider.settings.wind_particle_freq", (Object[])new Object[]{fmt.format(value)});
        }
    }

    private static final class SaveLoadAction {
        private final boolean isLoading;
        @Nullable
        private BooleanConsumer callback;
        private volatile State state = State.WAITING;
        private volatile long saveCompleteTimestamp;

        private SaveLoadAction(boolean isLoading, @Nullable BooleanConsumer callback) {
            this.isLoading = isLoading;
            this.callback = callback;
        }

        void update() {
            if (this.callback != null && this.isComplete()) {
                this.callback.accept(this.state == State.SUCCESS);
                this.callback = null;
            }
        }

        void notifySaveResult(boolean success) {
            if (this.state != State.WAITING) {
                return;
            }
            this.state = success ? State.SUCCESS : State.FAIL;
            this.saveCompleteTimestamp = ParagliderUtils.ms();
        }

        boolean isComplete() {
            return this.state != State.WAITING;
        }

        @NotNull
        Component text() {
            return this.isLoading ? this.state.loadText : this.state.saveText;
        }

        static enum State {
            WAITING("paraglider.settings.saving", "paraglider.settings.loading"),
            SUCCESS("paraglider.settings.saving.success", "paraglider.settings.loading.success"),
            FAIL("paraglider.settings.saving.failure", "paraglider.settings.loading.failure", ChatFormatting.RED);

            final Component saveText;
            final Component loadText;

            private State(String saveKey, String loadKey) {
                this.saveText = Component.translatable((String)saveKey);
                this.loadText = Component.translatable((String)loadKey);
            }

            private State(String saveKey, String loadKey, ChatFormatting fmt) {
                this.saveText = Component.translatable((String)saveKey).withStyle(fmt);
                this.loadText = Component.translatable((String)loadKey).withStyle(fmt);
            }
        }
    }
}

