/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderClientMod;
import tictim.paraglider.client.render.SettingsWidgetStaminaWheelRenderer;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.screen.DisableStaminaRender;
import tictim.paraglider.client.screen.ParagliderSettingsScreen;
import tictim.paraglider.client.settings.ExtraWheelAttachment;
import tictim.paraglider.client.settings.ParagliderClientSettings;
import tictim.paraglider.client.settings.StaminaWheelPosition;

public class StaminaWheelSettingScreen
extends Screen
implements DisableStaminaRender {
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("#.#%");
    private static final int ANCHOR_BUTTON_SIZE = 12;
    private final SettingsWidgetStaminaWheelRenderer wheelRenderer = new SettingsWidgetStaminaWheelRenderer();
    @Nullable
    private final ParagliderSettingsScreen parent;
    private final Component anchorText = Component.translatable((String)"paraglider.settings.stamina_wheel_settings.anchor");
    private final Component presetText = Component.translatable((String)"paraglider.settings.stamina_wheel_settings.preset");
    private StaminaWheelWidget staminaWheelWidget;
    private Button saveButton;
    private Button cancelButton;
    private List<Button> anchorButtons;
    private CycleButton<ExtraWheelAttachment> extraWheelAttachmentCycleButton;
    private List<Button> presetButtons;
    private Component[] helpText;
    private final StaminaWheelPosition initialPos;
    private ExtraWheelAttachment extraWheelAttachment;
    @Nullable
    private StaminaWheelPosition.Dir8 anchor;

    protected StaminaWheelSettingScreen(@Nullable ParagliderSettingsScreen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        ParagliderClientSettings settings = ParagliderClientSettings.get();
        this.initialPos = settings.staminaWheelPosition();
        this.extraWheelAttachment = settings.extraWheelAttachment();
        this.anchor = StaminaWheelSettingScreen.getAnchor(settings.staminaWheelPosition());
    }

    protected void init() {
        if (this.staminaWheelWidget == null) {
            this.staminaWheelWidget = new StaminaWheelWidget(this);
            this.staminaWheelWidget.setWheelPos(this.initialPos);
        }
        this.addRenderableWidget((GuiEventListener)this.staminaWheelWidget);
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"paraglider.settings.stamina_wheel_settings.save"), button -> {
            ParagliderClientSettings settings = ParagliderClientSettings.get();
            ParagliderClientSettings newSettings = new ParagliderClientSettings(this.staminaWheelWidget.toStaminaWheelPosition(this.anchor), settings.windParticleFrequency(), this.extraWheelAttachment);
            ParagliderClientMod.instance().setSettings(newSettings);
            if (this.parent != null) {
                this.parent.saveSettings();
            }
            this.onClose();
        }).bounds(0, 0, 48, 20).build());
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"paraglider.settings.stamina_wheel_settings.cancel"), button -> this.onClose()).bounds(0, 0, 48, 20).build());
        this.anchorButtons = List.of(this.anchorButton(StaminaWheelPosition.Dir8.UL), this.anchorButton(StaminaWheelPosition.Dir8.U), this.anchorButton(StaminaWheelPosition.Dir8.UR), this.anchorButton(StaminaWheelPosition.Dir8.L), this.anchorButton(null), this.anchorButton(StaminaWheelPosition.Dir8.R), this.anchorButton(StaminaWheelPosition.Dir8.DL), this.anchorButton(StaminaWheelPosition.Dir8.D), this.anchorButton(StaminaWheelPosition.Dir8.DR));
        this.extraWheelAttachmentCycleButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(e -> Component.literal((String)e.toString())).withValues((Object[])ExtraWheelAttachment.values()).withInitialValue((Object)this.extraWheelAttachment).create(0, 0, 64, 20, (Component)Component.empty(), (cycleButton, value) -> {
            this.extraWheelAttachment = value;
        }));
        this.presetButtons = List.of(this.presetButton("default", StaminaWheelPosition.DEFAULT, ExtraWheelAttachment.LEFT), this.presetButton("hud_center", new StaminaWheelPosition.Anchored(StaminaWheelPosition.Dir8.D, 0.0, -42.0), ExtraWheelAttachment.TOP), this.presetButton("hud_left", new StaminaWheelPosition.Anchored(StaminaWheelPosition.Dir8.D, -109.0, -35.0), ExtraWheelAttachment.LEFT), this.presetButton("hud_right", new StaminaWheelPosition.Anchored(StaminaWheelPosition.Dir8.D, 109.0, -35.0), ExtraWheelAttachment.RIGHT));
        this.helpText = new Component[]{Component.translatable((String)"paraglider.settings.stamina_wheel_settings.guide.0"), Component.translatable((String)"paraglider.settings.stamina_wheel_settings.guide.1"), Component.translatable((String)"paraglider.settings.stamina_wheel_settings.guide.1.2"), Component.translatable((String)"paraglider.settings.stamina_wheel_settings.guide.2", (Object[])new Object[]{this.minecraft.options.keyInventory.getTranslatedKeyMessage(), ParagliderClientMod.instance().getParagliderSettingsKey().getTranslatedKeyMessage()})};
    }

    private Button anchorButton(@Nullable StaminaWheelPosition.Dir8 value) {
        return (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> {
            this.anchor = value;
        }).bounds(0, 0, 12, 12).build());
    }

    private Button presetButton(@NotNull String langKey, @NotNull StaminaWheelPosition staminaWheelPosition, @NotNull ExtraWheelAttachment extraWheelAttachment) {
        return (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)("paraglider.settings.stamina_wheel_settings.preset." + langKey)), button -> this.applyPreset(staminaWheelPosition, extraWheelAttachment)).bounds(0, 0, 64, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Button button;
        int i;
        boolean wheelAtRight = this.staminaWheelWidget.wheelX >= (double)this.width / 2.0;
        boolean wheelAtDown = this.staminaWheelWidget.wheelY >= (double)this.height / 2.0;
        int topWidgetWidth = 172;
        Objects.requireNonNull(this.font);
        int topWidgetHeight = 2 + 9 + 2 + this.presetButtons.size() * 20 + 2;
        int topWidgetX = wheelAtRight ? 0 : this.width - topWidgetWidth;
        int topWidgetY = wheelAtDown ? this.height - topWidgetHeight : 0;
        int textWidth = Arrays.stream(this.helpText).mapToInt(e -> this.font.width((FormattedText)e)).max().orElse(0) + 6 + 48;
        int n = this.helpText.length;
        Objects.requireNonNull(this.font);
        int textHeight = Math.max(n * 9, 42) + 4;
        int textX = wheelAtRight ? 0 : this.width - textWidth;
        int textY = wheelAtDown ? 0 : this.height - textHeight;
        for (i = 0; i < this.anchorButtons.size(); ++i) {
            button = this.anchorButtons.get(i);
            Objects.requireNonNull(this.font);
            button.setPosition(topWidgetX + 2 + 12 * (i % 3), topWidgetY + 2 + 9 + 2 + 12 * (i / 3));
        }
        Objects.requireNonNull(this.font);
        this.extraWheelAttachmentCycleButton.setPosition(topWidgetX + 2 + 36 + 2, topWidgetY + 2 + 9 + 2);
        for (i = 0; i < this.presetButtons.size(); ++i) {
            button = this.presetButtons.get(i);
            Objects.requireNonNull(this.font);
            button.setPosition(topWidgetX + 2 + 36 + 2 + 64 + 2, topWidgetY + 2 + 9 + 2 + i * 20);
        }
        this.saveButton.setX(textX + textWidth - this.saveButton.getWidth() - 2);
        this.saveButton.setY(textY + textHeight - this.saveButton.getHeight() - 2);
        this.cancelButton.setX(textX + textWidth - this.cancelButton.getWidth() - 2);
        this.cancelButton.setY(textY + textHeight - this.saveButton.getHeight() - this.cancelButton.getHeight() - 4);
        guiGraphics.fillGradient(topWidgetX, topWidgetY, topWidgetX + topWidgetWidth, topWidgetY + topWidgetHeight, Integer.MIN_VALUE, Integer.MIN_VALUE);
        guiGraphics.fillGradient(textX, textY, textX + textWidth, textY + textHeight, Integer.MIN_VALUE, Integer.MIN_VALUE);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.anchorText, topWidgetX + 2, topWidgetY + 2, -1);
        guiGraphics.drawString(this.font, this.presetText, topWidgetX + 2 + 36 + 2 + 64 + 2, topWidgetY + 2, -1);
        int y = textY + 2;
        for (Component t : this.helpText) {
            guiGraphics.drawString(this.font, t, textX + 2, y, -16720045);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) || ParagliderClientMod.instance().getParagliderSettingsKey().getKey().equals((Object)mouseKey)) {
            this.onClose();
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (!this.minecraft.options.keyHotbarSlots[i].matches(keyCode, scanCode)) continue;
            if (i == 3) {
                this.wheelRenderer.setExtraWheels((this.wheelRenderer.extraWheels() + 1) % 3);
            } else {
                this.wheelRenderer.setWheels(i + 1);
            }
            return true;
        }
        return false;
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        this.staminaWheelWidget.onScreenResize(width, height);
        super.resize(minecraft, width, height);
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parent);
    }

    private void applyPreset(@NotNull StaminaWheelPosition staminaWheelPosition, @NotNull ExtraWheelAttachment extraWheelAttachment) {
        this.staminaWheelWidget.setWheelPos(staminaWheelPosition);
        this.anchor = StaminaWheelSettingScreen.getAnchor(staminaWheelPosition);
        this.extraWheelAttachment = extraWheelAttachment;
        this.extraWheelAttachmentCycleButton.setValue((Object)extraWheelAttachment);
    }

    @Nullable
    private static StaminaWheelPosition.Dir8 getAnchor(StaminaWheelPosition staminaWheelPosition) {
        StaminaWheelPosition staminaWheelPosition2 = staminaWheelPosition;
        Objects.requireNonNull(staminaWheelPosition2);
        StaminaWheelPosition staminaWheelPosition3 = staminaWheelPosition2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StaminaWheelPosition.Anchored.class, StaminaWheelPosition.ScreenProportion.class}, (Object)staminaWheelPosition3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                StaminaWheelPosition.Anchored anchored = (StaminaWheelPosition.Anchored)staminaWheelPosition3;
                yield anchored.anchor();
            }
            case 1 -> {
                StaminaWheelPosition.ScreenProportion ignored = (StaminaWheelPosition.ScreenProportion)staminaWheelPosition3;
                yield null;
            }
        };
    }

    public static class StaminaWheelWidget
    extends AbstractWidget {
        private final StaminaWheelSettingScreen screen;
        private double wheelX;
        private double wheelY;
        private boolean dragging;
        private double dragStartX;
        private double dragStartY;
        private double dragDeltaX;
        private double dragDeltaY;

        public StaminaWheelWidget(StaminaWheelSettingScreen screen) {
            super(0, 0, 20, 20, (Component)Component.empty());
            this.screen = screen;
        }

        public StaminaWheelPosition toStaminaWheelPosition(@Nullable StaminaWheelPosition.Dir8 anchor) {
            if (anchor == null) {
                return new StaminaWheelPosition.ScreenProportion(this.wheelX / (double)this.screen.width, this.wheelY / (double)this.screen.height);
            }
            return new StaminaWheelPosition.Anchored(anchor, this.wheelX - anchor.anchorX(this.screen.width), this.wheelY - anchor.anchorY(this.screen.height));
        }

        public void onScreenResize(int newWidth, int newHeight) {
            StaminaWheelPosition.Dir8 anchor = this.screen.anchor;
            if (anchor == null) {
                this.setWheelPos(this.wheelX / (double)this.screen.width * (double)newWidth, this.wheelY / (double)this.screen.height * (double)newHeight, newWidth, newHeight);
            } else {
                this.setWheelPos(this.wheelX - anchor.anchorX(this.screen.width) + anchor.anchorX(newWidth), this.wheelY - anchor.anchorY(this.screen.height) + anchor.anchorY(newHeight));
            }
        }

        public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int n;
            if (!this.visible) {
                return;
            }
            int color = StaminaWheelConstants.wheelColor(0);
            guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY(), color);
            guiGraphics.fill(this.getX() - 1, this.getY() + this.height, this.getX() + this.width + 1, this.getY() + this.height + 1, color);
            guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX(), this.getY() + this.height + 1, color);
            guiGraphics.fill(this.getX() + this.width, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, color);
            String s = Math.floor(this.wheelX) + ", " + Math.floor(this.wheelY);
            StaminaWheelPosition.Dir8 anchor = this.screen.anchor;
            String s2 = anchor == null ? PERCENTAGE.format(this.wheelX / (double)this.screen.width) + ", " + PERCENTAGE.format(this.wheelY / (double)this.screen.height) : String.valueOf((Object)anchor) + ": " + Math.floor(this.wheelX - anchor.anchorX(this.screen.width)) + ", " + Math.floor(this.wheelY - anchor.anchorY(this.screen.height));
            Font font = this.screen.font;
            int sw = font.width(s);
            int textX = Math.min(this.getX(), this.screen.width - sw - 3);
            if (this.wheelY >= (double)this.screen.height / 2.0) {
                int n2 = this.getY() - 1;
                Objects.requireNonNull(font);
                n = n2 - 9 * 2;
            } else {
                n = this.getY() + this.height + 2;
            }
            int textY = n;
            guiGraphics.drawString(font, s, textX, textY, color);
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, s2, textX, textY + 9, color);
            this.screen.wheelRenderer.render(guiGraphics, (float)(this.getX() + 10), (float)(this.getY() + 10), 0.0f, partialTicks, this.screen.extraWheelAttachment);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.active && this.visible && this.dragging && button == 1 && this.isMouseOver(mouseX, mouseY)) {
                this.dragging = false;
                this.setWheelPos(this.dragStartX, this.dragStartY);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public void onClick(double mouseX, double mouseY, int button) {
            this.dragStartX = this.wheelX;
            this.dragStartY = this.wheelY;
            this.dragDeltaY = 0.0;
            this.dragDeltaX = 0.0;
            this.dragging = true;
        }

        protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            this.dragDeltaX += dragX;
            this.dragDeltaY += dragY;
            this.setWheelPos(this.dragStartX + this.dragDeltaX, this.dragStartY + this.dragDeltaY);
        }

        public void onRelease(double mouseX, double mouseY) {
            if (this.dragging) {
                this.setWheelPos(this.dragStartX + this.dragDeltaX, this.dragStartY + this.dragDeltaY);
                this.dragging = false;
            }
        }

        public void playDownSound(@NotNull SoundManager handler) {
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput o) {
        }

        private void setWheelPos(StaminaWheelPosition pos) {
            this.setWheelPosUncapped(pos.x(this.screen.width), pos.y(this.screen.height));
        }

        private void setWheelPos(double x, double y) {
            this.setWheelPos(x, y, this.screen.width, this.screen.height);
        }

        private void setWheelPos(double x, double y, double width, double height) {
            this.setWheelPosUncapped(Math.clamp(x, 10.0, width - 10.0), Math.clamp(y, 10.0, height - 10.0));
        }

        private void setWheelPosUncapped(double x, double y) {
            this.wheelX = x;
            this.wheelY = y;
            this.setX((int)Math.floor(x) - 10);
            this.setY((int)Math.floor(y) - 10);
        }
    }
}

